<?php

/**
 * Class User
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\Response\Version3;

use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 * @package Sso\WebserviceBundle\Services\User\Update\Response\Version3
 */
final class User
{
    /**
     * @Serializer\SerializedName("Update")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\User\Update\Response\Version3\Update>")
     * @Serializer\XmlList(inline=true, entry="Update")
     * @var Update[]
     */
    private $update = array();

    /**
     * @param Update $update
     */
    public function addUpdate(Update $update)
    {
        $this->update[] = $update;
    }
}
