<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\User\Update\ResponseData;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\User\Show\ResponseData
 */
final class User
{
    /**
     * @var string
     */
    private $guid;

    /**
     * @var string|null
     */
    private $email;

    /**
     * @var string
     */
    private $username;

    /**
     * @var string
     */
    private $firstname;

    /**
     * @var string
     */
    private $lastname;

    /**
     * @var boolean
     */
    private $active;

    /**
     * @var string
     */
    private $activateToken;

    /**
     * @var \DateTime
     */
    private $activateTokenExpire;

    /**
     * @var string
     */
    private $authId;

    /**
     * @var string
     */
    private $ldapSearchAttributes;

    /**
     * @var string
     */
    private $ldapSearchValue;

    /**
     * @var boolean
     */
    private $deleted;

    /**
     * @var \DateTime
     */
    private $deletedAt;

    /**
     * @var \DateTime
     */
    private $createdAt;

    /**
     * @var \DateTime
     */
    private $updatedAt;

    /**
     * @var \DateTime
     */
    private $updatedReferencesAt;

    /**
     * @var \DateTime
     */
    private $lastLoginAt;

    /**
     * @var integer
     */
    private $loginFails;

    /**
     * @var boolean
     */
    private $mfaEnabled;

    /**
     * @var boolean
     */
    private $mfaRecreate;

    /**
     * Mfa secret create date
     *
     * @var \DateTime
     */
    private $mfaCreatedAt;

    /**
     * Mfa secret update date
     *
     * @var \DateTime
     */
    private $mfaUpdatedAt;

    /**
     * @var string
     */
    protected $passwordPolicy;

    /**
     * @var \DateTime|null
     */
    protected $lastPasswordChange;

    /**
     * @var integer
     */
    protected $passwordExpired;

    /**
     * @var string
     */
    private $passwordEncryptType;

    /**
     * @var array|string[]|null
     */
    private $userGroups;

    /**
     * @var array
     */
    private $requestMapper = [
        'getGuid' => 'setGuid',
        'getEmail' => 'setEmail',
        'getUsername' => 'setUsername',
        'getFirstname' => 'setFirstname',
        'getLastname' => 'setLastname',
        'getActive' => 'setActive',
        'getActivateToken' => 'setActivateToken',
        'getActivateTokenExpire' => 'setActivateTokenExpire',
        'getAuthId' => 'setAuthId',
        'getLdapSearchAttributes' => 'setLdapSearchAttributes',
        'getLdapSearchValue' => 'setLdapSearchValue',
        'isDeleted' => 'setDeleted',
        'getDeletedAt' => 'setDeletedAt',
        'getCreatedAt' => 'setCreatedAt',
        'getUpdatedAt' => 'setUpdatedAt',
        'getLastLoginAt' => 'setLastLoginAt',
        'isMfaEnabled' => 'setMfaEnabled',
        'getLoginFails' => 'setLoginFails',
        'isMfaRecreate' => 'setMfaRecreate',
        'getPasswordPolicy' => 'setPasswordPolicy',
        'getLastPasswordChange' => 'setLastPasswordChange',
        'isPasswordExpired' => 'setPasswordExpired',
        'getPasswordEncryptType' => 'setPasswordEncryptType',
        'getUserGroupNames' => 'setUserGroups',
    ];

    /**
     * @param UserModel $userModel
     * @return User
     */
    public function setFromUserModel(UserModel $userModel)
    {
        $responseData = new self();
        foreach ($this->requestMapper as $getter => $setter) {
            if (method_exists($userModel, $getter) && method_exists($responseData, $setter)) {
                $responseData->$setter($userModel->$getter());
            }
        }

        return $responseData;
    }

    /**
     * @return string
     */
    public function getGuid()
    {
        return $this->guid;
    }

    /**
     * @param string $guid
     */
    public function setGuid($guid)
    {
        $this->guid = (string)$guid;
    }

    /**
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * @param string|null $email
     */
    public function setEmail($email)
    {
        $this->email = (string)$email;
    }

    /**
     * @return string
     */
    public function getUsername()
    {
        return $this->username;
    }

    /**
     * @param string $username
     */
    public function setUsername($username)
    {
        $this->username = (string)$username;
    }

    /**
     * @return string
     */
    public function getFirstname()
    {
        return $this->firstname;
    }

    /**
     * @param string $firstname
     */
    public function setFirstname($firstname)
    {
        $this->firstname = (string)$firstname;
    }

    /**
     * @return string
     */
    public function getLastname()
    {
        return $this->lastname;
    }

    /**
     * @param string $lastname
     */
    public function setLastname($lastname)
    {
        $this->lastname = (string)$lastname;
    }

    /**
     * @return boolean
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     */
    public function setActive($active)
    {
        $this->active = (boolean)$active;
    }

    /**
     * @return string
     */
    public function getActivateToken()
    {
        return $this->activateToken;
    }

    /**
     * @param string $activateToken
     */
    public function setActivateToken($activateToken)
    {
        $this->activateToken = $activateToken;
    }

    /**
     * @return \DateTime
     */
    public function getActivateTokenExpire()
    {
        return $this->activateTokenExpire;
    }

    /**
     * @param \DateTime $activateTokenExpire
     */
    public function setActivateTokenExpire(\DateTime $activateTokenExpire = null)
    {
        $this->activateTokenExpire = $activateTokenExpire;
    }

    /**
     * @return string
     */
    public function getAuthId()
    {
        return $this->authId;
    }

    /**
     * @param string $authId
     */
    public function setAuthId($authId)
    {
        $this->authId = (string)$authId;
    }

    /**
     * @return string
     */
    public function getLdapSearchAttributes()
    {
        return $this->ldapSearchAttributes;
    }

    /**
     * @param string $ldapSearchAttributes
     */
    public function setLdapSearchAttributes($ldapSearchAttributes)
    {
        $this->ldapSearchAttributes = (string)$ldapSearchAttributes;
    }

    /**
     * @return string
     */
    public function getLdapSearchValue()
    {
        return $this->ldapSearchValue;
    }

    /**
     * @param string $ldapSearchValue
     */
    public function setLdapSearchValue($ldapSearchValue)
    {
        $this->ldapSearchValue = (string)$ldapSearchValue;
    }

    /**
     * @return boolean
     */
    public function isDeleted()
    {
        return $this->deleted;
    }

    /**
     * @param boolean $deleted
     */
    public function setDeleted($deleted)
    {
        $this->deleted = (boolean)$deleted;
    }

    /**
     * @return \DateTime
     */
    public function getDeletedAt()
    {
        return $this->deletedAt;
    }

    /**
     * @param \DateTime $deletedAt
     */
    public function setDeletedAt(\DateTime $deletedAt  = null)
    {
        $this->deletedAt = $deletedAt;
    }

    /**
     * @return \DateTime
     */
    public function getCreatedAt()
    {
        return $this->createdAt;
    }

    /**
     * @param \DateTime $createdAt
     */
    public function setCreatedAt(\DateTime $createdAt = null)
    {
        $this->createdAt = $createdAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedAt()
    {
        return $this->updatedAt;
    }

    /**
     * @param \DateTime $updatedAt
     */
    public function setUpdatedAt(\DateTime $updatedAt = null)
    {
        $this->updatedAt = $updatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getUpdatedReferencesAt()
    {
        return $this->updatedReferencesAt;
    }

    /**
     * @param \DateTime $updatedReferencesAt
     */
    public function setUpdatedReferencesAt(\DateTime $updatedReferencesAt = null)
    {
        $this->updatedReferencesAt = $updatedReferencesAt;
    }

    /**
     * @return \DateTime
     */
    public function getLastLoginAt()
    {
        return $this->lastLoginAt;
    }

    /**
     * @param \DateTime $lastLoginAt
     */
    public function setLastLoginAt(\DateTime $lastLoginAt = null)
    {
        $this->lastLoginAt = $lastLoginAt;
    }

    /**
     * @return boolean
     */
    public function isMfaEnabled()
    {
        return $this->mfaEnabled;
    }

    /**
     * @param boolean $mfaEnabled
     */
    public function setMfaEnabled($mfaEnabled)
    {
        $this->mfaEnabled = (boolean)$mfaEnabled;
    }

    /**
     * @return \DateTime
     */
    public function getMfaCreatedAt()
    {
        return $this->mfaCreatedAt;
    }

    /**
     * @param \DateTime $mfaCreatedAt
     */
    public function setMfaCreatedAt(\DateTime $mfaCreatedAt = null)
    {
        $this->mfaCreatedAt = $mfaCreatedAt;
    }

    /**
     * @return \DateTime
     */
    public function getMfaUpdatedAt()
    {
        return $this->mfaUpdatedAt;
    }

    /**
     * @param \DateTime $mfaUpdatedAt
     */
    public function setMfaUpdatedAt(\DateTime $mfaUpdatedAt)
    {
        $this->mfaUpdatedAt = $mfaUpdatedAt;
    }

    /**
     * @return int
     */
    public function getLoginFails()
    {
        return $this->loginFails;
    }

    /**
     * @param int $loginFails
     */
    public function setLoginFails($loginFails)
    {
        $this->loginFails = (int)$loginFails;
    }

    /**
     * @return boolean
     */
    public function isMfaRecreate()
    {
        return $this->mfaRecreate;
    }

    /**
     * @param boolean $mfaRecreate
     * @return User
     */
    public function setMfaRecreate($mfaRecreate)
    {
        $this->mfaRecreate = $mfaRecreate;

        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordPolicy()
    {
        return $this->passwordPolicy;
    }

    /**
     * @param string $passwordPolicy
     * @return User
     */
    public function setPasswordPolicy($passwordPolicy)
    {
        $this->passwordPolicy = $passwordPolicy;
        return $this;
    }

    /**
     * @return \DateTime|null
     */
    public function getLastPasswordChange()
    {
        return $this->lastPasswordChange;
    }

    /**
     * @param \DateTime|null $lastPasswordChange
     * @return User
     */
    public function setLastPasswordChange($lastPasswordChange)
    {
        $this->lastPasswordChange = $lastPasswordChange instanceof \DateTime ? clone $lastPasswordChange : null;
        return $this;
    }

    /**
     * @return int
     */
    public function getPasswordExpired()
    {
        return $this->passwordExpired;
    }

    /**
     * @param int $passwordExpired
     * @return User
     */
    public function setPasswordExpired($passwordExpired)
    {
        $this->passwordExpired = $passwordExpired;
        return $this;
    }

    /**
     * @return string
     */
    public function getPasswordEncryptType(): string
    {
        return $this->passwordEncryptType;
    }

    /**
     * @param string $passwordEncryptType
     */
    public function setPasswordEncryptType(string $passwordEncryptType): void
    {
        $this->passwordEncryptType = $passwordEncryptType;
    }

    /**
     * @return array|string[]|null
     */
    public function getUserGroups()
    {
        return $this->userGroups;
    }

    /**
     * @param array|string[]|null $userGroups
     */
    public function setUserGroups($userGroups): void
    {
        $this->userGroups = $userGroups;
    }
}
