<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\Delete\RequestData;

/**
 * Class ApplicationType
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserApplication\Delete\RequestData
 */
final class ApplicationType
{
    const BOOLEAN_TRUE = true;
    const BOOLEAN_FALSE = false;

    /**
     * @var string
     */
    private $name = '';

    /**
     * @var bool
     */
    private $force = null;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;
        return $this;
    }

    /**
     * @return int
     */
    public function isForce()
    {
        return $this->force;
    }

    /**
     * @param int $force
     * @return ApplicationType
     */
    public function setForce($force)
    {
        if ( (null !== $force) ) {
            $this->force = $force == 1 ? static::BOOLEAN_TRUE : static::BOOLEAN_FALSE;
        }

        return $this;
    }
}
