<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\ShowDetails;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\ApiVersionInflectorInterface;
use Sso\WebserviceBundle\Services\HandlerFactoryInterface;
use Sso\WebserviceBundle\Services\HandlerInterface;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\RequestFactoryInterface;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\ResponseFactoryInterface;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplication\ShowDetails
 */
final class Factory implements HandlerFactoryInterface
{
    /**
     * @var ApiManagerInterface
     */
    private $apiM;

    /**
     * @var ApiVersionInflectorInterface
     */
    private $apiVersionInflector;

    /**
     * @var array
     */
    private $factory = array();

    /**
     * Factory constructor.
     * @param ApiManagerInterface $apiM
     * @param ApiVersionInflectorInterface $apiVersionInflector
     */
    public function __construct(ApiManagerInterface $apiM, ApiVersionInflectorInterface $apiVersionInflector)
    {
        $this->apiM = $apiM;
        $this->apiVersionInflector = $apiVersionInflector;
    }

    /**
     * @return RequestFactoryInterface
     */
    public function request()
    {
        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = (new Request\Factory($this->apiM, $this->apiVersionInflector, $this->requestData()))->factory());
    }

    /**
     * @return ResponseFactoryInterface
     */
    public function response()
    {
        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = (new Response\Factory($this->apiM, $this->apiVersionInflector))->factory());
    }

    /**
     * @return RequestData\Factory
     */
    public function requestData()
    {
        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = new RequestData\Factory());
    }

    /**
     * @return ResponseData\Factory
     */
    public function responseData()
    {
        return isset($this->factory[__METHOD__]) ? $this->factory[__METHOD__] : ($this->factory[__METHOD__] = new ResponseData\Factory());
    }

    /**
     * @return Handler
     */
    public function handler()
    {
        return new Handler($this, $this->apiM->database()->webservice()->user(), $this->apiM->errorHandler());
    }
}
