<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplication\ShowDetails\ResponseData;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserApplication\ShowDetails\ResponseData
 */
final class ApplicationType
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var boolean
     */
    private $active;

    /**
     * @var AttributeType[]
     */
    private $attributeType;

    /**
     * @var ApplicationRoleType[]
     */
    private $applicationRoleType;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
        $this->applicationRoleType = new ArrayCollection();

    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return integer
     */
    public function getActive()
    {
        return $this->active ? 1: 0;
    }

    /**
     * @param boolean $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active ? 1 : 0;

        return $this;
    }

    /**
     * @param AttributeType[] $attributeType
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        $this->attributeType->add($attributeType);
    }

    /**
     * @param ApplicationRoleType[] $applicationRoleType
     */
    public function addApplicationRoleType(ApplicationRoleType $applicationRoleType)
    {
        $this->applicationRoleType->add($applicationRoleType);
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @return ApplicationRoleType[]
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }
}
