<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Add
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2
 */
class Add
{
    /**
     * @Assert\NotNull()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Key")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2\Key")
     *
     * @var Key
     */
    private $key;

    /**
     * @Assert\NotNull()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2\Value")
     *
     * @var Value
     */
    private $value;

    /**
     * @return Key
     */
    public function getKey(): Key
    {
        return $this->key;
    }

    /**
     * @return Value
     */
    public function getValue(): Value
    {
        return $this->value;
    }
}
