<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2;

use Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\AttributeTypeInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Sso\WebserviceBundle\Validator\Constraints as SsoAssert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class AttributeType
 *
 * @SsoAssert\ApplicationAttributeValue()
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2
 */
class AttributeType implements AttributeTypeInterface
{
    /**
     * @Assert\NotBlank()
     *
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $name;

    /**
     * @Assert\NotBlank()
     * @Assert\Choice({"one", "many", "generator"})
     *
     * @Serializer\SerializedName("Type")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $type;

    /**
     * @Assert\NotBlank()
     *
     * @Serializer\SerializedName("Value")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $value;

    /**
     * @return string
     */
    public function getName(): string
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getType(): string
    {
        return $this->type;
    }

    /**
     * @return string
     */
    public function getValue(): string
    {
        return $this->value;
    }
}
