<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2;

use Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\UserTypeInterface;
use Symfony\Component\Validator\Constraints as Assert;
use Sso\WebserviceBundle\Validator\Constraints as SsoAssert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @SsoAssert\UserTypeIdentifier()
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2
 */
class UserType implements UserTypeInterface
{
    /**
     * @Serializer\SerializedName("Identifier")
     * @Serializer\Type("string")
     * @var string
     */
    private $identifier;

    /**
     * @Serializer\SerializedName("Username")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $username;

    /**
     * @Serializer\SerializedName("Guid")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $guid;

    /**
     * @Assert\Email()
     *
     * @Serializer\SerializedName("Email")
     * @Serializer\Type("string")
     *
     * @var string
     */
    private $email;

    /**
     * @return string
     */
    public function getIdentifier(): string
    {
        return $this->identifier;
    }

    /**
     * @return bool
     */
    public function hasIdentifier(): bool
    {
        return null !== $this->identifier;
    }

    /**
     * @return string
     */
    public function getUsername(): string
    {
        return $this->username;
    }

    /**
     * @return bool
     */
    public function hasUsername(): bool
    {
        return null !== $this->username;
    }

    /**
     * @return string
     */
    public function getGuid(): string
    {
        return $this->guid;
    }

    /**
     * @return bool
     */
    public function hasGuid(): bool
    {
        return null !== $this->guid;
    }

    /**
     * @return string
     */
    public function getEmail(): string
    {
        return $this->email;
    }

    /**
     * @return bool
     */
    public function hasEmail(): bool
    {
        return null !== $this->email;
    }
}
