<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2;

use Sso\WebserviceBundle\Validator\Constraints as SsoAssert;
use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Value
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2
 */
class Value
{
    /**
     * @Serializer\SerializedName("ForceAttributeAdd")
     * @Serializer\Type("integer")
     * @Serializer\Accessor(setter="setForceAttributeAddFromInt")
     *
     * @var bool
     */
    private $forceAttributeAdd = false;

    /**
     * @Assert\NotNull()
     * @Assert\Valid
     * @SsoAssert\UserApplicationAttributes
     *
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("array<Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Request\Version2\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="AttributeType")
     *
     * @var AttributeType[]
     */
    private $attributeTypes;

    /**
     * @param $forceAttributeAdd
     */
    public function setForceAttributeAddFromInt($forceAttributeAdd): void
    {
        $this->forceAttributeAdd = (bool)$forceAttributeAdd;
    }

    /**
     * @return bool
     */
    public function isForceAttributeAdd(): bool
    {
        return $this->forceAttributeAdd;
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeTypes(): array
    {
        return $this->attributeTypes;
    }
}
