<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response\Version2;

use JMS\Serializer\SerializerInterface;
use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\EventListener\PerformanceListener;
use Sso\WebserviceBundle\Services\ResponseBuilderInterface as GlobalResponseBuilderInterface;
use Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\ResponseBuilderInterface;

/**
 * Class ResponseBuilder
 *
 * @copyright  2018 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserApplicationAttribute\Add\Response\Version2
 */
class ResponseBuilder implements ResponseBuilderInterface, GlobalResponseBuilderInterface
{
    /**
     * @var SerializerInterface
     */
    private $serializer;

    /**
     * @var Factory
     */
    private $factory;

    /**
     * @var ErrorHandlerInterface
     */
    private $errorHandler;

    /**
     * @var PerformanceListener
     */
    private $performanceService;

    /**
     * ResponseBuilder constructor.
     * @param SerializerInterface $serializer
     * @param Factory $factory
     * @param ErrorHandlerInterface $errorHandler
     * @param PerformanceListener $performanceService
     */
    public function __construct(
        SerializerInterface $serializer,
        Factory $factory,
        ErrorHandlerInterface $errorHandler,
        PerformanceListener $performanceService
    ) {
        $this->serializer = $serializer;
        $this->factory = $factory;
        $this->errorHandler = $errorHandler;
        $this->performanceService = $performanceService;
    }

    /**
     * @return bool
     */
    public function hasErrors(): bool
    {
        return $this->errorHandler->hasErrors();
    }

    /**
     * @param string $format xml|json
     * @return string Response body
     */
    /**
     * @param string $format xml|json
     * @return string Response body
     */
    public function build($format)
    {
        $response = $this->errorHandler->hasErrors() ? $this->getErrorResponse() : $this->getSuccessResponse();
        return $this->serializer->serialize($response, $format);
    }

    /**
     * @return Response
     */
    private function getErrorResponse(): Response
    {
        $response = $this->factory->response();
        $response->setErrors($this->errorHandler->getResponseObject());

        return $response;
    }

    /**
     * @return Response
     */
    private function getSuccessResponse(): Response
    {
        $action = $this->factory->add();
        $action->setStatus('Success');

        $controller = $this->factory->userApplicationAttribute();
        $controller->setAdd($action);

        $response = $this->factory->response();
        $response->setCode(200);
        $response->setStatus('Success');
        $response->setScriptTimeSec($this->performanceService->getScriptSeconds());
        $response->setUserApplicationAttribute($controller);

        return $response;
    }
}
