<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserApplicationRole\Show\ResponseData;

use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserApplicationRole\ShowDetails\ResponseData
 */
final class ApplicationType
{
    /**
     * @var string
     */
    private $name;

    /**
     * @var boolean
     */
    private $active;


    /**
     * @var RoleType[]
     */
    private $applicationRoleType;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
        $this->applicationRoleType = new ArrayCollection();

    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return boolean
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param boolean $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @param RoleType[] $applicationRoleType
     */
    public function addApplicationRoleType(RoleType $applicationRoleType)
    {
        $this->applicationRoleType->add($applicationRoleType);
    }

     /**
     * @return RoleType[]
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }
}
