<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Add\Response\Version2;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\ErrorHandler\Response\ErrorsObjectInterface;

/**
 * Class Add
 * @package Sso\WebserviceBundle\Services\UserGroup\Add\Response\Version2
 */
final class Add
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("UserGroupType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserGroup\Add\Response\Version2\UserGroupType")
     * @var UserGroupType
     */
    private $userGroupType;

    /**
     * @param string $status
     * @return Add
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param UserGroupType $userGroupType
     * @return Add
     */
    public function setUserGroupType($userGroupType)
    {
        $this->userGroupType = $userGroupType;
        return $this;
    }
}
