<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       https://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserGroup\Search\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Search
 *
 * @Serializer\XmlRoot("Search")
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserGroup\Search\Request\Version2
 */
class Search
{
    /**
     * @Assert\Type(type="integer")
     * @Assert\GreaterThan(value=0)
     *
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("integer")
     * @var int
     */
    private $limit = 25;

    /**
     * @Assert\Type(type="integer")
     * @Assert\GreaterThanOrEqual(value=0)
     *
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("integer")
     * @var int
     */
    private $offset = 0;

    /**
     * @return int
     */
    public function getLimit(): int
    {
        return $this->limit;
    }

    /**
     * @return int
     */
    public function getOffset(): int
    {
        return $this->offset;
    }
}
