<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider;

use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Class DataProvider
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider
 */
final class DataProvider implements DataProviderInterface
{
    const TYPE_DOCTRINE = "Doctrine";
    const TYPE_ELASTICA = "Elastica";

    /**
     * @var ContainerInterface
     */
    private $container;

    /**
     * @var string
     */
    private $queryType;

    /**
     * DataProvider constructor.
     * @param ContainerInterface $container
     * @param string $queryType
     */
    public function __construct(ContainerInterface $container, string $queryType = 'Doctrine')
    {
        $this->container = $container;
        $this->queryType = $queryType;
    }

    /**
     * @return HandlerInterface
     */
    public function queryHandler()
    {
        //currently we can only handle doctrine
        return $this->container->get(
            'sso_webservice.services_user_search_advanced_data_provider_' . strtolower($this->queryType) . '.handler'
        );
    }

    /**
     * @param string $queryType
     * @return DataProvider
     */
    public function setQueryType($queryType)
    {
        if(in_array($queryType, [static::TYPE_DOCTRINE, static::TYPE_ELASTICA])){
            $this->queryType = $queryType;
        } else {
            $this->queryType = static::TYPE_DOCTRINE;
        }

        return $this;
    }
}
