<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\Elastica;

use Sso\WebserviceBundle\Exception\InvalidConfigurationException;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\HandlerInterface;
use Doctrine\Bundle\DoctrineBundle\Registry as DoctrineRegistry;
use Symfony\Component\HttpKernel\Log\LoggerInterface;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\RequestData\UserSearch as RequestDTO;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\ResponseData\Users as ResponseDTO;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\Factory;

/**
 * Class Handler
 * @package Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\Doctrine
 */
final class Handler implements HandlerInterface
{
    /**
     * @var DoctrineRegistry
     */
    private $doctrineRegistry;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Factory
     */
    private $factory;

    /**
     * DataProvider constructor.
     * @param DoctrineRegistry $doctrineRegistry
     * @param LoggerInterface $logger
     */
    public function __construct(DoctrineRegistry $doctrineRegistry, LoggerInterface $logger)
    {
        $this->doctrineRegistry = $doctrineRegistry;
        $this->logger = $logger;
    }

    /**
     * @param RequestDTO $requestDTO
     * @return ResponseDTO
     */
    public function getResponseDTO(RequestDTO $requestDTO, Factory $factory)
    {
        $this->factory = $factory;
        throw new InvalidConfigurationException('Data provider Elastic Search not implemented yet.');
    }
}
