<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced;

use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\HandlerInterface;
use Sso\WebserviceBundle\Services\RequestInterface as ServiceRequestInterface;
use Sso\WebserviceBundle\Services\ResponseBuilderInterface as ServiceResponseBuilderInterface;
use Sso\WebserviceBundle\Database\Manager as DatabaseManager;
use Symfony\Component\DependencyInjection\ContainerInterface;
use Sso\WebserviceBundle\Services\UserSearch\Advanced\DataProvider\DataProviderInterface;

/**
 * Class Handler
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\User\ShowDetails
 */
final class Handler implements HandlerInterface
{
    /**
     * @var Factory
     */
    private $factory;

    /**
     * @var DatabaseManager
     */
    private $dbM;

    /**
     * @var ErrorHandlerInterface
     */
    private $errorHandler;

    /**
     * @var DataProviderInterface
     */
    private $dataProvider;

    /**
     * Handler constructor.
     * @param Factory $factory
     * @param DatabaseManager $database
     * @param ErrorHandlerInterface $errorHandler
     * @param ContainerInterface $container
     */
    public function __construct(
        Factory $factory,
        DatabaseManager $database,
        ErrorHandlerInterface $errorHandler,
        DataProviderInterface $dataProvider
    ) {
        $this->factory = $factory;
        $this->dbM = $database;
        $this->errorHandler = $errorHandler;
        $this->dataProvider = $dataProvider;
    }

    /**
     * @param ServiceRequestInterface $request
     * @return ServiceResponseBuilderInterface
     */
    public function handle(ServiceRequestInterface $request)
    {
        //get request DTO
        $requestDTO = $this->factory->request()->requestParser()->parse($request->getRequestBody());

        //set response builder
        $responseBuilder = $this->factory->response()->responseBuilder();
        if ($this->errorHandler->hasErrors()) {
            return $responseBuilder;
        }

        // catch exceptions doctine/elasticsearch here
        try{
            $responseDTO = $this->dataProvider->queryHandler()->getResponseDTO($requestDTO, $this->factory);
        }catch (\Exception $exc){
            $message = 'The regular expression is not valid!';
            $this->errorHandler->addError(400, 'usx1', 'sql', 'invalid query', $message, $exc);
            return $responseBuilder;
        }

        $responseBuilder->setResponse($responseDTO);

        return $responseBuilder;
    }
}
