<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class UserType
 *
 * @Serializer\XmlRoot("ApplicationType")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2
 */
final class ApplicationType
{
    /**
     * @Assert\NotBlank()
     *
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Assert\Regex(
     *     pattern="/(0|1)/",
     *     match=true,
     *     message="The Active Flag can only contain 0 or 1"
     * )
     *
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $active;

    /**
     * @Assert\Valid
     *
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2\AttributeType")
     * @var AttributeType
     */
    private $attributeType;

    /**
     * @Assert\Valid
     *
     * @Serializer\SerializedName("RoleType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\Advanced\Request\Version2\RoleType")
     * @var RoleType
     */
    private $roleType;

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return int
     */
    public function getActive()
    {
        return $this->active;
    }

    /**
     * @param int $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @return AttributeType
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @param AttributeType $attributeType
     * @return ApplicationType
     */
    public function setAttributeType($attributeType)
    {
        $this->attributeType = $attributeType;

        return $this;
    }

    /**
     * @return RoleType
     */
    public function getRoleType()
    {
        return $this->roleType;
    }

    /**
     * @param RoleType $roleType
     * @return ApplicationType
     */
    public function setRoleType($roleType)
    {
        $this->roleType = $roleType;

        return $this;
    }

    /**
     * @return bool
     */
    public function isRegularExpressionValid()
    {
        if (@preg_match('/' . str_replace('/', '\/', $this->name) . '/', null) === false) {
            return false;
        }
        if (null !== $this->attributeType && !$this->attributeType->isRegularExpressionValid()) {
            return false;
        }
        if (null !== $this->roleType && !$this->roleType->isRegularExpressionValid()) {
            return false;
        }
        return true;
    }
}

