<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\RequestData;

/**
 * Class Factory
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserSearch\Advanced\RequestData
 */
final class Factory
{
    /**
     * @return UserSearch
     */
    public function userSearch()
    {
        return new UserSearch();
    }

    /**
     * @return Filter
     */
    public function filter()
    {
        return new Filter();
    }

    /**
     * @return UserType
     */
    public function userType()
    {
        return new UserType();
    }

    /**
     * @return RoleType
     */
    public function roleType()
    {
        return new RoleType();
    }

    /**
     * @return AttributeType
     */
    public function attributeType()
    {
        return new AttributeType();
    }

    /**
     * @return ApplicationType
     */
    public function applicationType()
    {
        return new ApplicationType();
    }
}
