<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Advanced
 * @package Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Response\Version2
 */
final class Advanced
{
    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Count")
     * @Serializer\Type("integer")
     * @var string
     */
    private $count;

    /**
     * @Serializer\SerializedName("Offset")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $offset;

    /**
     * @Serializer\SerializedName("Limit")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $limit;

    /**
     * @Serializer\SerializedName("OrderBy")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderBy;

    /**
     * @Serializer\SerializedName("OrderDir")
     * @Serializer\Type("string")
     * @var string
     */
    private $orderDir;

    /**
     * @Serializer\SerializedName("FullResponse")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $fullResponse;

    /**
     * @Serializer\SerializedName("Users")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2\Users")
     * @var Users
     */
    private $users;

    /**
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * @return mixed
     */
    public function getCount()
    {
        return $this->count;
    }

    /**
     * @return integer
     */
    public function getOffset()
    {
        return $this->offset;
    }

    /**
     * @return int
     */
    public function getLimit()
    {
        return $this->limit;
    }

    /**
     * @return string
     */
    public function getOrderBy()
    {
        return $this->orderBy;
    }

    /**
     * @param string $orderBy
     * @return Advanced
     */
    public function setOrderBy($orderBy)
    {
        $this->orderBy = $orderBy;

        return $this;
    }

    /**
     * @return string
     */
    public function getOrderDir()
    {
        return $this->orderDir;
    }

    /**
     * @param string $orderDir
     * @return Advanced
     */
    public function setOrderDir($orderDir)
    {
        $this->orderDir = $orderDir;

        return $this;
    }

    /**
     * @return int
     */
    public function getFullResponse()
    {
        return $this->fullResponse;
    }

    /**
     * @param int $fullResponse
     * @return Advanced
     */
    public function setFullResponse($fullResponse)
    {
        $this->fullResponse = $fullResponse;

        return $this;
    }

    /**
     * @param string $status
     * @return Advanced
     */
    public function setStatus($status)
    {
        $this->status = $status;

        return $this;
    }

    /**
     * @param mixed $count
     * @return Advanced
     */
    public function setCount($count)
    {
        $this->count = $count;

        return $this;
    }

    /**
     * @param integer $offset
     * @return Advanced
     */
    public function setOffset($offset)
    {
        $this->offset = $offset;

        return $this;
    }

    /**
     * @param int $limit
     * @return Advanced
     */
    public function setLimit($limit)
    {
        $this->limit = $limit;

        return $this;
    }

    /**
     * @param Users $users
     * @return Advanced
     */
    public function setUsers(Users $users)
    {
        $this->users = $users;

        return $this;
    }

    /**
     * @return Users
     */
    public function getUsers()
    {
        return $this->users;
    }
}
