<?php

/**
 * Class UserType
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class ApplicationType
 * @package Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2
 */
final class ApplicationType
{
    /**
     * @Serializer\SerializedName("Name")
     * @Serializer\Type("string")
     * @var string
     */
    private $name;

    /**
     * @Serializer\SerializedName("Active")
     * @Serializer\Type("integer")
     * @var integer
     */
    private $active;
    
    /**
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2\AttributeType>")
     * @Serializer\XmlList(inline=true, entry="AttributeType")
     * @var AttributeType[]
     */
    private $attributeType;

    /**
     * @Serializer\SerializedName("ApplicationRoleType")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version2\ApplicationRoleType>")
     * @Serializer\XmlList(inline=true, entry="ApplicationRoleType")
     * @var ApplicationRoleType[]
     */
    private $applicationRoleType;

    /**
     * ApplicationType constructor.
     */
    public function __construct()
    {
        $this->attributeType = new ArrayCollection();
        $this->applicationRoleType = new ArrayCollection();

    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @param string $name
     * @return ApplicationType
     */
    public function setName($name)
    {
        $this->name = $name;

        return $this;
    }

    /**
     * @return integer
     */
    public function isActive()
    {
        return $this->active;
    }

    /**
     * @param integer $active
     * @return ApplicationType
     */
    public function setActive($active)
    {
        $this->active = $active;

        return $this;
    }

    /**
     * @param AttributeType[] $attributeType
     */
    public function addAttributeType(AttributeType $attributeType)
    {
        $this->attributeType->add($attributeType);
    }

    /**
     * @param ApplicationRoleType[] $applicationRoleType
     */
    public function addApplicationRoleType(ApplicationRoleType $applicationRoleType)
    {
        $this->applicationRoleType->add($applicationRoleType);
    }

    /**
     * @return AttributeType[]
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }

    /**
     * @return ApplicationRoleType[]
     */
    public function getApplicationRoleType()
    {
        return $this->applicationRoleType;
    }
}
