<?php

/**
 * Class Show
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version3;

use Doctrine\Common\Collections\ArrayCollection;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class User
 * @package Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version3
 */
final class User
{
    /**
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version3\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("ArrayCollection<Sso\WebserviceBundle\Services\UserSearch\Advanced\Response\Version3\ApplicationType>")
     * @Serializer\XmlList(inline = true, entry = "ApplicationType")
     * @var ApplicationType[]
     */
    private $applicationType;


    public function __construct()
    {
        $this->applicationType = new ArrayCollection();
    }

    /**
     * @param string $status
     * @return User
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param UserType $userType
     * @return User
     */
    public function setUserType($userType)
    {
        $this->userType = $userType;
        return $this;
    }

    /**
     * @param ApplicationType $applicationType
     * @return User
     */
    public function addApplicationType(ApplicationType $applicationType)
    {
        $this->applicationType->add($applicationType);

        return $this;
    }
}
