<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplication\ResponseData;

use Sso\WebserviceBundle\Entity\Webservice\Type\User as UserModel;
use Doctrine\Common\Collections\ArrayCollection;

/**
 * Class UserData
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserSearch\FindByApplication\ResponseData
 */
final class UserData
{

    /**
     * @var UserType[]
     */
    private $userType;

    /**
     * @var array
     */
    private $userTypeMapper = [
        'getGuid' => 'setGuid',
        'getEmail' => 'setEmail',
        'getActive' => 'setActive'
    ];

    /**
     * UserData constructor.
     */
    public function __construct()
    {
        $this->userType = new ArrayCollection();
    }

    /**
     * @param array $usersArray
     * @return UserData
     */
    public function setFromUsers(array $usersArray)
    {
        $responseData = new self();
        foreach ($usersArray as $user){
            $userType = new UserType();
            $userType->setGuid($user['Guid']);
            $userType->setEmail($user['Email']);
            $userType->setUsername($user['Username']);

            // get a proper bool value from (int)Active for the DTO
            $userType->setActive( $user['Active'] == 1 );

            $responseData->addUserType($userType);
        }


        return $responseData;
    }

    /**
     * @param UserType $userType
     */
    private function addUserType(UserType $userType)
    {
        $this->userType->add($userType);

    }

    /**
     * @return UserType[]
     */
    public function getUserType()
    {
        return $this->userType;
    }
}
