<?php

/**
 * Class Key
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2;

use Symfony\Component\Validator\Constraints as Assert;
use JMS\Serializer\Annotation as Serializer;

/**
 * Class Key
 *
 * @Serializer\XmlRoot("Key")
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2;
 */
final class Key
{

    /**
     * @Assert\Valid
     *
     * @Serializer\SerializedName("UserType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2\UserType")
     * @var UserType
     */
    private $userType;

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("ApplicationType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2\ApplicationType")
     * @var ApplicationType
     */
    private $applicationType;

    /**
     * @Assert\NotBlank()
     * @Assert\Valid
     *
     * @Serializer\SerializedName("AttributeType")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\FindByApplicationAttribute\Request\Version2\AttributeType")
     * @var AttributeType
     */
    private $attributeType;

    /**
     * @return UserType
     */
    public function getUserType()
    {
        return $this->userType;
    }

    /**
     * @return ApplicationType
     */
    public function getApplicationType()
    {
        return $this->applicationType;
    }

    /**
     * @return AttributeType
     */
    public function getAttributeType()
    {
        return $this->attributeType;
    }
}
