<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\RequestData;

/**
 * Class User
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\RequestData
 */
final class UserSearch
{
    /**
     * @var \DateTime
     */
    private $modifiedAfter = null;

    /**
     * @var string
     */
    private $applicationName = null;

    /**
     * @var boolean|null
     */
    private $applicationActive = null;

    /**
     * @var string
     */
    private $roleName = null;

    /**
     * @var boolean|null
     */
    private $roleActive = null;

    /**
     * @return \DateTime
     */
    public function getModifiedAfter()
    {
        return $this->modifiedAfter;
    }

    /**
     * @param \DateTime $modifiedAfter
     * @return UserSearch
     */
    public function setModifiedAfter( \DateTime $modifiedAfter)
    {
        $this->modifiedAfter = $modifiedAfter;
        return $this;
    }

    /**
     * @return string
     */
    public function getApplicationName()
    {
        return $this->applicationName;
    }

    /**
     * @param string $applicationName
     * @return UserSearch
     */
    public function setApplicationName($applicationName)
    {
        $this->applicationName = $applicationName;
        return $this;
    }

    /**
     * @return int
     */
    public function isApplicationActive()
    {
        return $this->applicationActive;
    }

    /**
     * @param null|integer $applicationActive
     * @return UserSearch
     */
    public function setApplicationActive($applicationActive)
    {
        if(null !== $applicationActive){
            $this->applicationActive = ($applicationActive == 1);
        } else {
            // this line is not required i added it for a better understanding
            // the world is neither fair nor unfair...
            $this->applicationActive = $applicationActive;
        }

        return $this;
    }

    /**
     * @return string
     */
    public function getRoleName()
    {
        return $this->roleName;
    }

    /**
     * @param string $roleName
     * @return UserSearch
     */
    public function setRoleName($roleName)
    {
        $this->roleName = $roleName;
        return $this;
    }

    /**
     * @return boolean
     */
    public function isRoleActive()
    {
        return $this->roleActive;
    }

    /**
     * @param null|integer $roleActive
     * @return UserSearch
     */
    public function setRoleActive($roleActive)
    {
        if(null !== $roleActive){
            $this->roleActive = ($roleActive == 1);
        } else {
            $this->roleActive = $roleActive;
        }

        return $this;
    }
}
