<?php

/**
 * Class Response
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Response\Version2;

use JMS\Serializer\Annotation as Serializer;
use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;
use Sso\WebserviceBundle\ErrorHandler\Response\ResponseInterface as ErrorsInterface;
use Sso\WebserviceBundle\Model\ResponseStatusTrait;

/**
 * Class Response
 * @package  Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Response\Version2
 * @Serializer\XmlRoot(name="SsoResponse")
 */
final class Response
{
    use ResponseStatusTrait;

    /**
     * @Serializer\SerializedName("Code")
     * @Serializer\Type("integer")
     * @var string
     */
    private $code;

    /**
     * @Serializer\SerializedName("Status")
     * @Serializer\Type("string")
     * @var string
     */
    private $status;

    /**
     * @Serializer\SerializedName("Trackid")
     * @Serializer\Type("string")
     * @var string
     */
    private $trackid;

    /**
     * @Serializer\SerializedName("Date")
     * @Serializer\Type("DateTime")
     * @var \DateTime
     */
    private $date;

    /**
     * @Serializer\SerializedName("ScriptTimeSec")
     * @Serializer\Type("double")
     * @var double
     */
    private $scriptTimeSec;

    /**
     * @Serializer\SerializedName("UserSearch")
     * @Serializer\Type("Sso\WebserviceBundle\Services\UserSearch\FindByApplicationRole\Response\Version2\UserSearch")
     * @var UserSearch
     */
    private $userSearch;

    /**
     * @Serializer\XmlList(inline = true)
     * @var ErrorsInterface
     */
    private $errors;

    /**
     * Response constructor.
     */
    public function __construct()
    {
        $this->date = new \DateTime();
        $this->trackid = ApiException::getTrackId();
    }

    /**
     * @param string $code
     */
    public function setCode($code)
    {
        $this->code = $code;
        $this->status = $this->statusCodeToStatus($code);

        return $this;
    }


    /**
     * @param string $status
     * @return Response
     */
    public function setStatus($status)
    {
        $this->status = $status;
        return $this;
    }

    /**
     * @param float $scriptTimeSec
     */
    public function setScriptTimeSec($scriptTimeSec)
    {
        $this->scriptTimeSec = $scriptTimeSec;
    }

    /**
     * @param UserSearch $userSearch
     */
    public function setUserSearch(UserSearch $userSearch)
    {
        $this->userSearch = $userSearch;
    }

    /**
     * @param string $trackid
     * @return Response
     */
    public function setTrackid($trackid)
    {
        $this->trackid = $trackid;

        return $this;
    }

    /**
     * @param \DateTime $date
     * @return Response
     */
    public function setDate($date)
    {
        $this->date = $date;

        return $this;
    }

    /**
     * @param ErrorsInterface $errors
     * @return Response
     */
    public function setErrors(ErrorsInterface $errors)
    {
        $this->errors = $errors;

        return $this;
    }
}
