<?php

/**
 * User: sb
 * Date: 19.05.2014
 * Time: 17:10
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH   * (Aschaffenburg, Germany)
 * and is protected by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2014 Lifestyle Webconsulting GmbH
 * @version    $Id$
 * @link       www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Api;

use Sso\WebserviceBundle\Tests\FunctionalTestCase;
use Sso\WebserviceBundle\Api\Credentials\Index as Credentials;

/**
 * Class CredentialsTest
 * @package Sso\WebserviceBundle\Tests\Api
 */
class CredentialsTest extends FunctionalTestCase
{
    /**
     * @var string
     */
    private $validControllerName = 'User';

    /**
     * @var string
     */
    private $validActionName = 'Add';

    /**
     * @var string
     */
    private $validRemoteAddress = '120.44.52.1';

    /**
     * @param null $serviceToken
     * @param null $userIdentifier
     * @return \SimpleXMLElement
     */
    private function _xmlCredentials($serviceToken = null, $userIdentifier = null)
    {
        return simplexml_load_string("<?xml version='1.0'?>
            <Credentials>
                    <ServiceProvider>
                        <ServiceToken>" . (null === $serviceToken ? $this->ServiceToken : $serviceToken) . "</ServiceToken>
                        <ServiceName>" . $this->ServiceName . "</ServiceName>
                    </ServiceProvider>
                    <ServiceTrigger>
                        <UserIdentifier>" . (null === $userIdentifier ? $this->idpUserIdentifier : $userIdentifier) . "</UserIdentifier>
                    </ServiceTrigger>
                    <ServiceCountry>
                        <Code>" . $this->ServiceCountryCode . "</Code>
                    </ServiceCountry>
                </Credentials>");
    }

    /**
     * Invalid service token
     * @expectedException \Sso\WebserviceBundle\Api\Credentials\Exception
     */
    public function testInvalidServiceTokenError()
    {
        $credentials = new Credentials($this->apiM);
        $token = substr($this->ServiceToken, 1);
        $credentials->validateCredentials($this->_xmlCredentials($token), $this->validControllerName, $this->validActionName, $this->validRemoteAddress);
    }

    /**
     * Invalid user identifier - length check
     * @expectedException \Sso\WebserviceBundle\Api\Credentials\Exception
     */
    public function testInvalidUserIdentifierLengthError()
    {
        $credentials = new Credentials($this->apiM);
        $userIdentifier = substr($this->idpUserIdentifier, 1);
        $credentials->validateCredentials($this->_xmlCredentials(null, $userIdentifier), $this->validControllerName, $this->validActionName, $this->validRemoteAddress);
    }

    /**
     * Invalid user identifier
     * @expectedException \Sso\WebserviceBundle\Api\Credentials\Exception
     */
    public function testInvalidUserIdentifierError()
    {
        $credentials = new Credentials($this->apiM);
        $userIdentifier = substr($this->idpUserIdentifier, 1) . '_';
        $credentials->validateCredentials($this->_xmlCredentials(null, $userIdentifier), $this->validControllerName, $this->validActionName, $this->validRemoteAddress);
    }
}
