<?php

namespace Sso\WebserviceBundle\Tests\Controller;

use Sso\WebserviceBundle\Api\Exception\Type\Api as ApiException;
use Sso\WebserviceBundle\Tests\FunctionalTestCase;

class UserControllerTest extends FunctionalTestCase
{
    /**
     * Username for testing
     * @var string
     */
    protected $Username;

    /**
     * Email for testing
     * @var string
     */
    protected $Email;

    /**
     * Setup some defaults
     */
    public function setUp()
    {
        parent::setUp();

        date_default_timezone_set('Europe/Berlin');
        $this->Username = 'TestUser-UC-' . date('Ymd');
        $this->Email = $this->Username . '@test.com';
    }


    public function testUserController(){
        $this->userAddSuccess();
        $this->userShowSuccess();
        $this->userUpdateSuccess();
        $this->userChangePasswordSuccess();
        $this->userDeleteSuccess();
    }

    /**
     * Test user add - successful
     */
    public function userAddSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Add>
                        <Value>
                          <UserType>
                            <Email>' . $this->Email . '</Email>
                            <Username>' . $this->Username . '</Username>
                            <Firstname>Testers firstname</Firstname>
                            <Lastname>Testers lastname</Lastname>
                            <Password>SumpfTest#1234</Password>
                            <Active>0</Active>
                          </UserType>
                        </Value>
                        </Add>
                      </User>
                    </SsoRequest>';

        try {
            $xmlResponse = $this->xmlResponse();
            $this->apiM->controller()->getController('User', 'Add', $xml, $xmlResponse)->callAction('Add');
            $response = $xmlResponse->output();
        } catch (ApiException $exc) {
            $this->fail("Test 'user add' has failed. \nErrors:\n" . implode("\n", $exc->getErrors()));
            return;
        }

        $this->assertContains('<Status>Success</Status>', $response);
    }

    /**
     * Test user add - invalid username containing whitespaces
     */
    public function testUserAddInvalidUsername()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Add>
                        <Value>
                          <UserType>
                            <Email>' . $this->Email . '</Email>
                            <Username>' . $this->Username . ' AnyWhitspace</Username>
                            <Firstname>Testers firstname</Firstname>
                            <Lastname>Testers lastname</Lastname>
                            <Password>SumpfTest#1234</Password>
                            <Active>0</Active>
                          </UserType>
                        </Value>
                        </Add>
                      </User>
                    </SsoRequest>';

        $xmlResponse = $this->xmlResponse();
        $this->apiM->controller()->getController('User', 'Add', $xml, $xmlResponse)->callAction('Add');
        $response = $xmlResponse->output();

        $this->assertContains('<Status>Failure</Status>', $response);
        $this->assertContains('<ErrorCode><![CDATA[u24]]></ErrorCode>', $response);
        $this->assertContains('<ShortMessage><![CDATA[Invalid username]]></ShortMessage>', $response);
        $this->assertContains('<LongMessage><![CDATA[Username should not have any whitespaces.]]></LongMessage>', $response);
    }

    /**
     * Test user show - successful
     */
    public function userShowSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Show>
                        <Key>
                          <UserType>
                            <Username>' . $this->Username . '</Username>
                          </UserType>
                        </Key>
                        </Show>
                      </User>
                    </SsoRequest>';

        try {
            $xmlResponse = $this->xmlResponse();
            $this->apiM->controller()->getController('User', 'Show', $xml, $xmlResponse)->callAction('Show');
            $response = $xmlResponse->output();
        } catch (ApiException $exc) {
            $this->fail("Test 'user Show' has failed. \nErrors:\n" . implode("\n", $exc->getErrors()));
            return;
        }
        $this->assertContains('<Guid>', $response);
        $this->assertContains('<Username>' . $this->Username . '</Username>', $response);
        $this->assertContains('<Email>' . $this->Email . '</Email>', $response);
        $this->assertContains('<Firstname>Testers firstname</Firstname>', $response);
        $this->assertContains('<Lastname>Testers lastname</Lastname>', $response);
        $this->assertContains('<Active>0</Active>', $response);
        $this->assertContains('<Status>Success</Status>', $response);
    }

    /**
     * Test user update - successful
     */
    public function userUpdateSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Update>
                        <Key>
                          <UserType>
                                <Username>' . $this->Username . '</Username>
                          </UserType>
                        </Key>
                        <Value>
                          <UserType>
                            <Email>foobar' . $this->Email . '</Email>
                            <Firstname>Testers firstname changed</Firstname>
                            <Lastname>Testers lastname changed</Lastname>
                            <Active>0</Active>
                          </UserType>
                        </Value>
                        </Update>
                      </User>
                    </SsoRequest>';

        try {
            $xmlResponse = $this->xmlResponse();
            $this->apiM->controller()->getController('User', 'Update', $xml, $xmlResponse)->callAction('Update');
            $response = $xmlResponse->output();
        } catch (ApiException $exc) {
            $this->fail("Test 'user Update' has failed. \nErrors:\n" . implode("\n", $exc->getErrors()));
            return;
        }
        $this->assertContains('<Status>Success</Status>', $response);
    }

    /**
     * Test user update - invalid username
     */
    public function userUpdateFailure()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Update>
                        <Key>
                          <UserType>
                                <Username>' . $this->Username . '</Username>
                          </UserType>
                        </Key>
                        <Value>
                          <UserType>
                            <Username>Username with whitespace</Username>
                            <Firstname>Testers firstname changed</Firstname>
                            <Lastname>Testers lastname changed</Lastname>
                            <Active>0</Active>
                          </UserType>
                        </Value>
                        </Update>
                      </User>
                    </SsoRequest>';

        try {
            $xmlResponse = $this->xmlResponse();
            $this->apiM->controller()->getController('User', 'Update', $xml, $xmlResponse)->callAction('Update');
            $response = $xmlResponse->output();
        } catch (ApiException $exc) {
            $this->fail("Test 'user Update' has failed. \nErrors:\n" . implode("\n", $exc->getErrors()));
            return;
        }
        $this->assertContains('<Status>Failure</Status>', $response);
        $this->assertContains('<ErrorCode><![CDATA[u24]]></ErrorCode>', $response);
        $this->assertContains('<ShortMessage><![CDATA[Invalid username]]></ShortMessage>', $response);
        $this->assertContains('<LongMessage><![CDATA[Username should not have any whitespaces.]]></LongMessage>', $response);
    }

    /**
     * Test user change password - successful
     */
    public function userChangePasswordSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <ChangePassword>
                        <Key>
                          <UserType>
                                <Username>' . $this->Username . '</Username>
                          </UserType>
                        </Key>
                        <Value>
                          <UserType>
                            <Password>Jhwu23#4sfdfs</Password>
                          </UserType>
                        </Value>
                        </ChangePassword>
                      </User>
                    </SsoRequest>';

        try {
            $xmlResponse = $this->xmlResponse();
            $this->apiM->controller()->getController('User', 'ChangePassword', $xml, $xmlResponse)->callAction('ChangePassword');
            $response = $xmlResponse->output();
        } catch (ApiException $exc) {
            $this->fail("Test 'user ChangePassword' has failed. \nErrors:\n" . implode("\n", $exc->getErrors()));
            return;
        }
        $this->assertContains('<Status>Success</Status>', $response);
    }

    /**
     * Test user delete - successful
     */
    public function userDeleteSuccess()
    {
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $this->xmlCredentials . '
                      <User>
                        <Delete>
                            <Key>
                              <UserType>
                                <Username>' . $this->Username . '</Username>
                              </UserType>
                            </Key>
                        </Delete>
                      </User>
                    </SsoRequest>';

        try {
            $xmlResponse = $this->xmlResponse();
            $this->apiM->controller()->getController('User', 'Delete', $xml, $xmlResponse)->callAction('Delete');
            $response = $xmlResponse->output();
        } catch (ApiException $exc) {
            $this->fail("Test 'user delete' has failed. \nErrors:\n" . implode("\n", $exc->getErrors()));
            return;
        }

        $this->assertContains('<Status>Success</Status>', $response);
    }
}
