<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\EventListener;

use Sso\WebserviceBundle\EventListener\RequestHeaderListener;
use Psr\Log\LoggerInterface;
use Symfony\Component\HttpKernel\Event\GetResponseEvent;
use Symfony\Component\HttpKernel\HttpKernelInterface;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpKernel\KernelEvents;

class RequestHeaderListenerTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var LoggerInterface
     */
    private $logger;

    protected function setUp()
    {
        $this->logger = $this->createMock(LoggerInterface::class);
    }

    public function testHeaderAcceptAllSuccess()
    {
        $event = $this->factoryGetResponseEvent();
        $event->getRequest()->headers->set('Accept', '*/*');

        $object = new RequestHeaderListener($this->logger);
        $object->addHeaders($event);

        $this->assertSame('*/*', $event->getRequest()->headers->get('Accept'));
    }

    public function testHeaderAcceptJsonSuccess()
    {
        $event = $this->factoryGetResponseEvent();
        $event->getRequest()->headers->set('Accept', 'application/json');

        $object = new RequestHeaderListener($this->logger);
        $object->addHeaders($event);

        $this->assertSame('application/json', $event->getRequest()->headers->get('Accept'));
    }

    public function testHeaderAcceptAddSuccess()
    {
        $event = $this->factoryGetResponseEvent();
        $event->getRequest()->headers->remove('Accept');

        $object = new RequestHeaderListener($this->logger);
        $object->addHeaders($event);

        $this->assertSame('*/*', $event->getRequest()->headers->get('Accept'));
    }

    public function testHeaderAcceptEmptySuccess()
    {
        $event = $this->factoryGetResponseEvent();
        $event->getRequest()->headers->set('Accept', '');

        $object = new RequestHeaderListener($this->logger);
        $object->addHeaders($event);

        $this->assertSame('*/*', $event->getRequest()->headers->get('Accept'));
    }

    public function testHeaderAcceptNoneStringSuccess()
    {
        $event = $this->factoryGetResponseEvent();
        $event->getRequest()->headers->set('Accept', 'none');

        $object = new RequestHeaderListener($this->logger);
        $object->addHeaders($event);

        $this->assertSame('*/*', $event->getRequest()->headers->get('Accept'));
    }

    public function testSubscribedEvents()
    {
        $subscribedEvents = RequestHeaderListener::getSubscribedEvents();

        $this->assertCount(1, $subscribedEvents);
        $this->assertArrayHasKey(KernelEvents::REQUEST, $subscribedEvents);
        $this->assertSame(array('addHeaders', 1024), $subscribedEvents[KernelEvents::REQUEST]);
    }

    /**
     * @return GetResponseEvent
     */
    private function factoryGetResponseEvent()
    {
        $request = Request::create('/', 'OPTIONS');
        $httpKernel = $this->createMock(HttpKernelInterface::class, array(), array($request));
        return new GetResponseEvent($httpKernel, $request, HttpKernelInterface::MASTER_REQUEST);
    }
}
