<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional;

use Sso\WebserviceBundle\Tests\FunctionalTestCase;

/**
 * Class CredentialsTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Functional
 */
class CredentialsTest extends FunctionalTestCase
{

    /**
     * @param $serviceToken
     * @param $serviceName
     * @param $userIdentifier
     * @param $serviceCountryCode
     * @param $userName
     * @return string
     */
    private function credentials($serviceToken, $serviceName, $userIdentifier, $serviceCountryCode, $userName)
    {
        return "<Credentials>
                    <ServiceProvider>
                        <ServiceToken>" . $serviceToken . "</ServiceToken>
                        <ServiceName>" . $serviceName . "</ServiceName>
                    </ServiceProvider>
                    <ServiceTrigger>
                        <Username>" . $userName . "</Username>
                        <UserIdentifier>" . $userIdentifier . "</UserIdentifier>
                    </ServiceTrigger>
                    <ServiceCountry>
                        <Code>" . $serviceCountryCode . "</Code>
                    </ServiceCountry>
                </Credentials>";
    }

    public function testServiceTokenError()
    {
        $serviceToken = substr($this->ServiceToken, 1) . 'Q';
        $credentials = $this->credentials($serviceToken, $this->ServiceName, $this->idpUserIdentifier, $this->ServiceCountryCode, $this->userName);
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $credentials . '
                        <User>
                            <Show>
                              <UserType>
                                <Username></Username>
                              </UserType>
                            </Show>
                        </User>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'User', 'Show');
        $this->assertContains('<ErrorCode><![CDATA[fw004]]></ErrorCode>', $response->getContent());
    }

    public function testUserIdentifierError()
    {
        $userIdentifier = substr($this->idpUserIdentifier, 1) . 'Q';
        $credentials = $this->credentials($this->ServiceToken, $this->ServiceName, $userIdentifier, $this->ServiceCountryCode, $this->userName);
        $xml = '<?xml version="1.0"?>
                    <SsoRequest>' . $credentials . '
                        <User>
                            <Show>
                                <Key>
                                  <UserType>
                                    <Username></Username>
                                  </UserType>
                                </Key>
                            </Show>
                        </User>
                    </SsoRequest>';
        $response = $this->sendRequest($xml, 'User', 'Show');
        $this->assertContains('<ErrorCode><![CDATA[fw004]]></ErrorCode>', $response->getContent());
    }
}
