<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper;

/**
 * Class Credentials
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */
class Credentials
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * Credentials constructor.
     * @param Configuration $configuration
     */
    public function __construct(Configuration $configuration)
    {
        $this->configuration = $configuration;
    }

    /**
     * @return string
     */
    public function __toString()
    {
        return '<Credentials>
    <ServiceProvider>
        <ServiceToken>' . $this->cdata($this->configuration->getServiceToken()) . '</ServiceToken>
        <ServiceName>MyService</ServiceName>
    </ServiceProvider>
    <ServiceTrigger>
        <Username>' . $this->cdata($this->configuration->getUsername()) . '</Username>
        <UserIdentifier>' . $this->cdata($this->configuration->getUserIdentifier()) . '</UserIdentifier>
    </ServiceTrigger>
    <ServiceCountry>
        <Code>DE</Code>
    </ServiceCountry>
</Credentials>';
    }

    /**
     * @param string $value
     * @return string
     */
    private function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
