<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Application\Add as ApplicationAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Application\Delete as ApplicationDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\ApplicationAttribute\Add as ApplicationAttributeAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\ApplicationAttribute\Delete as ApplicationAttributeDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\ApplicationRole\Add as ApplicationRoleAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\ApplicationRole\Delete as ApplicationRoleDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\User\Add as UserAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\User\Delete as UserDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\User\Show as UserShow;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserApplication\Add as UserApplicationAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserApplication\Delete as UserApplicationDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserApplicationAttribute\Add as UserApplicationAttributeAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserApplicationAttribute\Delete as UserApplicationAttributeDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserApplicationRole\Add as UserApplicationRoleAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserApplicationRole\Delete as UserApplicationRoleDelete;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserPermission\Add as UserPermissionAdd;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\UserService\PasswordRequest as UserServicePasswordRequest;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Symfony\Bundle\FrameworkBundle\Client;

/**
 * Class Factory
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Functional\Services\Helper\Version1
 */
class Factory
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Factory constructor.
     * @param Configuration $configuration
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @return ApplicationAdd
     */
    public function applicationAdd()
    {
        return new ApplicationAdd($this->configuration, $this->client);
    }

    /**
     * @return ApplicationDelete
     */
    public function applicationDelete()
    {
        return new ApplicationDelete($this->configuration, $this->client);
    }

    /**
     * @return ApplicationAttributeAdd
     */
    public function applicationAttributeAdd()
    {
        return new ApplicationAttributeAdd($this->configuration, $this->client);
    }

    /**
     * @return ApplicationAttributeDelete
     */
    public function applicationAttributeDelete()
    {
        return new ApplicationAttributeDelete($this->configuration, $this->client);
    }

    /**
     * @return ApplicationRoleAdd
     */
    public function applicationRoleAdd()
    {
        return new ApplicationRoleAdd($this->configuration, $this->client);
    }

    /**
     * @return ApplicationRoleDelete
     */
    public function applicationRoleDelete()
    {
        return new ApplicationRoleDelete($this->configuration, $this->client);
    }

    /**
     * @return UserAdd
     */
    public function userAdd()
    {
        return new UserAdd($this->configuration, $this->client);
    }

    /**
     * @return UserShow
     */
    public function userShow()
    {
        return new UserShow($this->configuration, $this->client);
    }

    /**
     * @return UserDelete
     */
    public function userDelete()
    {
        return new UserDelete($this->configuration, $this->client);
    }

    /**
     * @return UserApplicationAdd
     */
    public function userApplicationAdd()
    {
        return new UserApplicationAdd($this->configuration, $this->client);
    }

    /**
     * @return UserApplicationDelete
     */
    public function userApplicationDelete()
    {
        return new UserApplicationDelete($this->configuration, $this->client);
    }

    /**
     * @return UserApplicationAttributeAdd
     */
    public function userApplicationAttributeAdd()
    {
        return new UserApplicationAttributeAdd($this->configuration, $this->client);
    }

    /**
     * @return UserApplicationAttributeDelete
     */
    public function userApplicationAttributeDelete()
    {
        return new UserApplicationAttributeDelete($this->configuration, $this->client);
    }

    /**
     * @return UserApplicationRoleAdd
     */
    public function userApplicationRoleAdd()
    {
        return new UserApplicationRoleAdd($this->configuration, $this->client);
    }

    /**
     * @return UserApplicationRoleDelete
     */
    public function userApplicationRoleDelete()
    {
        return new UserApplicationRoleDelete($this->configuration, $this->client);
    }

    /**
     * @return UserServicePasswordRequest
     */
    public function userServicePasswordRequest()
    {
        return new UserServicePasswordRequest($this->configuration, $this->client);
    }

    /**
     * @return UserPermissionAdd
     */
    public function userPermissionAdd()
    {
        return new UserPermissionAdd($this->configuration, $this->client);
    }
}
