<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model;

/**
 * Class UserApplicationRole
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version1\Model
 */
class UserApplicationRole
{
    /**
     * @var User
     */
    private $user;

    /**
     * @var Application
     */
    private $application;

    /**
     * @var ApplicationRole
     */
    private $role;

    /**
     * UserApplicationRole constructor.
     * @param User $user
     * @param Application $application
     * @param ApplicationRole $role
     */
    public function __construct(User $user, Application $application, ApplicationRole $role)
    {
        $this->user = $user;
        $this->application = $application;
        $this->role = $role;
    }

    /**
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @return Application
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * @return ApplicationRole
     */
    public function getRole()
    {
        return $this->role;
    }
}
