<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\ApplicationAttribute;

use Symfony\Bundle\FrameworkBundle\Client;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\ApplicationAttribute;
use Faker\Factory;

/**
 * Class Add
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version2\ApplicationAttribute
 */
class Add
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Add constructor.
     * @param Configuration $configuration
     * @param Client $client
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @param Application $application
     * @return ApplicationAttribute
     */
    public function execute(Application $application)
    {
        $faker = Factory::create();
        $applicationAttribute = new ApplicationAttribute(Constants::PREFIX . $faker->lastName);
        $applicationAttribute->setValue(Constants::PREFIX . $faker->lastName);
        $applicationAttribute->setType('one');
        $applicationAttribute->setDisplayType('dropdown');
        $applicationAttribute->setAttributeOptions(['Label 1' => 'one', 'Label 2' => 'two']);

        $this->client->request(
            'POST',
            $this->configuration->getUrlUserWs(),
            [],
            [],
            [
                'HTTP_API-CONTROLLER' => 'ApplicationAttribute',
                'HTTP_API-ACTION' => 'Add',
                'CONTENT-TYPE' => 'text/xml; charset=UTF-8',
                'HTTP_API-VERSION' => '2',
                'HTTP_REMOTE_ADDR' => '127.0.0.1',
            ],
            $this->getRequest($application, $applicationAttribute)
        );

        return $applicationAttribute;
    }

    /**
     * @param Application $application
     * @param ApplicationAttribute $applicationAttribute
     * @return string
     */
    private function getRequest(Application $application, ApplicationAttribute $applicationAttribute)
    {
        $displayType = $applicationAttribute->getDisplayType();
        if (null !== $displayType) {
            $displayType = '<DisplayType>' . $this->cdata($displayType) . '</DisplayType>';
        }

        $attributeOptions = [];
        foreach ($applicationAttribute->getAttributeOptions() ?? [] as $label => $value) {
            $attributeOptions[$label] = '<AttributeOption>' .
                '<Label>' . $this->cdata($label) . '</Label>' .
                '<Value>' . $this->cdata($value) . '</Value>' .
                '</AttributeOption>';
        }

        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <ApplicationAttribute>
        <Add>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($application->getName()) . '</Name>
                </ApplicationType>
            </Key>
            <Value>
                <AttributeType>
                    <Name>' . $this->cdata($applicationAttribute->getName()) . '</Name>
                    <Type>' . $this->cdata($applicationAttribute->getType()) . '</Type>
                    ' . $displayType . '
                    ' . implode('', $attributeOptions) . '
                </AttributeType>
            </Value>
        </Add>
    </ApplicationAttribute>
</SsoRequest>';
    }

    /**
     * @param string $value
     * @return string
     */
    protected function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
