<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model;

/**
 * Class UserApplicationAttribute
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version2\Model
 */
class UserApplicationAttribute
{
    /**
     * @var User
     */
    private $user;

    /**
     * @var Application
     */
    private $application;

    /**
     * @var ApplicationAttribute
     */
    private $applicationAttribute;

    /**
     * UserApplicationAttribute constructor.
     * @param User $user
     * @param Application $application
     * @param ApplicationAttribute $applicationAttribute
     */
    public function __construct(User $user, Application $application, ApplicationAttribute $applicationAttribute)
    {
        $this->user = $user;
        $this->application = $application;
        $this->applicationAttribute = $applicationAttribute;
    }

    /**
     * @return User
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * @return Application
     */
    public function getApplication()
    {
        return $this->application;
    }

    /**
     * @return ApplicationAttribute
     */
    public function getApplicationAttribute()
    {
        return $this->applicationAttribute;
    }
}
