<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\User;

use Symfony\Bundle\FrameworkBundle\Client;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\User;
use Faker\Factory;

/**
 * Class Add
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version2\User
 */
class Add
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Add constructor.
     * @param Configuration $configuration
     * @param Client $client
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @param bool $userActive
     * @param bool $mfaEnabled
     * @return User
     */
    public function execute($userActive = false, $mfaEnabled = false)
    {
        $faker = Factory::create();
        $user = new User();
        $user->setEmail(Constants::PREFIX . $faker->email);
        $user->setUsername(Constants::PREFIX . $faker->userName);
        $user->setActive((bool)$userActive);
        $user->setMfaEnabled((bool)$mfaEnabled);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $this->client->request(
            'POST',
            $this->configuration->getUrlUserWs(),
            [],
            [],
            [
                'HTTP_API-CONTROLLER' => 'User',
                'HTTP_API-ACTION' => 'Add',
                'CONTENT-TYPE' => 'text/xml; charset=UTF-8',
                'HTTP_API-VERSION' => '2',
                'HTTP_REMOTE_ADDR' => '127.0.0.1',
            ],
            $this->getRequest($user)
        );

        $xml = $this->client->getResponse()->getContent();
        $xmlSimple = simplexml_load_string($xml);
        $user->setGuid((string)$xmlSimple->User->Add->UserType->Guid);
        if (isset($xmlSimple->User->Add->UserType->ActivateToken)) {
            $user->setActivateToken((string)$xmlSimple->User->Add->UserType->ActivateToken);
        }

        return $user;
    }

    /**
     * @param User $user
     * @return string
     */
    private function getRequest(User $user)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '<User>
        <Add>
            <Value>
                <UserType>
                    <Email>' . $this->cdata($user->getEmail()) . '</Email>
                    <Username>' . $this->cdata($user->getUsername()) . '</Username>
                    <Firstname>' . $this->cdata($user->getFirstname()) . '</Firstname>
                    <Lastname>' . $this->cdata($user->getLastname()) . '</Lastname>
                    <Password>' . $this->cdata($user->getPassword()) . '</Password>
                    <Active>' . ($user->isActive() ? '1' : '0') . '</Active>
                    <MfaEnabled>' . ($user->isMfaEnabled() ? '1' : '0') . '</MfaEnabled>
                    <AuthId>' . $this->cdata($user->getAuthId()) . '</AuthId>
                    <LdapSearchAttributes>' . $this->cdata($user->getLdapSearchAttributes()) . '</LdapSearchAttributes>
                    <LdapSearchValue>' . $this->cdata($user->getLdapSearchValue()) . '</LdapSearchValue>
                </UserType>
            </Value>
        </Add>
    </User>
</SsoRequest>';
    }

    /**
     * @param string $value
     * @return string
     */
    protected function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
