<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\UserApplicationAttribute;

use Symfony\Bundle\FrameworkBundle\Client;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\ApplicationAttribute;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\User;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\UserApplicationAttribute;

/**
 * Class Add
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Version2\UserApplicationAttribute
 */
class Add
{
    /**
     * @var Configuration
     */
    private $configuration;

    /**
     * @var Client
     */
    private $client;

    /**
     * Add constructor.
     * @param Configuration $configuration
     * @param Client $client
     */
    public function __construct(Configuration $configuration, Client $client)
    {
        $this->configuration = $configuration;
        $this->client = $client;
    }

    /**
     * @param User $user
     * @param Application $application
     * @param ApplicationAttribute $applicationAttribute
     * @return UserApplicationAttribute
     */
    public function execute(User $user, Application $application, ApplicationAttribute $applicationAttribute)
    {
        $userApplicationAttribute = new UserApplicationAttribute($user, $application, $applicationAttribute);
        $this->client->request(
            'POST',
            $this->configuration->getUrlUserWs(),
            [],
            [],
            [
                'HTTP_API-CONTROLLER' => 'UserApplicationAttribute',
                'HTTP_API-ACTION' => 'Add',
                'CONTENT-TYPE' => 'text/xml; charset=UTF-8',
                'HTTP_API-VERSION' => '2',
                'HTTP_REMOTE_ADDR' => '127.0.0.1',
            ],
            $this->getRequest($userApplicationAttribute)
        );

        return $userApplicationAttribute;
    }

    /**
     * @param UserApplicationAttribute $userApplicationAttribute
     * @return string
     */
    private function getRequest(UserApplicationAttribute $userApplicationAttribute)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserApplicationAttribute>
        <Add>
            <Key>
                <UserType>
                    <Username>' . $this->cdata($userApplicationAttribute->getUser()->getUsername()) . '</Username>
                </UserType>
                <ApplicationType>
                    <Name>' . $this->cdata($userApplicationAttribute->getApplication()->getName()) . '</Name>
                </ApplicationType>
            </Key>
            <Value>
                <AttributeType>
                    <Name>' . $this->cdata($userApplicationAttribute->getApplicationAttribute()->getName()) . '</Name>
                    <Type>' . $this->cdata($userApplicationAttribute->getApplicationAttribute()->getType()) . '</Type>
                    <Value>' . $this->cdata($userApplicationAttribute->getApplicationAttribute()->getValue()) . '</Value>
                </AttributeType>
            </Value>
        </Add>
    </UserApplicationAttribute>
</SsoRequest>';
    }

    /**
     * @param string $value
     * @return string
     */
    protected function cdata($value)
    {
        return '<![CDATA[' . $value . ']]>';
    }
}
