<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version1;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model\Application;

/**
 * Class ApplicationAddTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version1
 */
class ApplicationAddTest extends FunctionalTestCase
{
    public function testValidApplication()
    {
        $faker = \Faker\Factory::create();
        $application = new Application();
        $application->setName(Constants::PREFIX . $faker->lastName);
        $application->setDescription($faker->sentence);
        $application->setActive(false);

        $requestBody = $this->getRequest($application);
        $response = $this->sendPostRequest('Application', 'Add', $requestBody);

        static::assertEquals(200, $response->getStatusCode(), $response->getContent());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testInvalidApplication()
    {
        $application = new Application();
        $application->setName('');
        $application->setDescription('');

        $requestBody = $this->getRequest($application);
        $response = $this->sendPostRequest('Application', 'Add', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Application->Add->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertEquals(
            'a10',
            (string)$xmlSimple->Application->Add->Errors->Error->ErrorCode,
            'Error code does not match!'
        );
    }

    /**
     * @param Application $application
     * @return string
     */
    private function getRequest(Application $application)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <Application>
        <Add>
            <Value>
                <ApplicationType>
                    <Name>' . $this->cdata($application->getName()) . '</Name>
                    <Description>' . $this->cdata($application->getDescription()) . '</Description>
                </ApplicationType>
            </Value>
        </Add>
    </Application>
</SsoRequest>';
    }
}
