<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version1\Credentials;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;

/**
 * Class CredentialsTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version1\Credentials
 */
class CredentialsTest extends FunctionalTestCase
{

    public function testInvalidCredentials()
    {
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);
        static::assertEquals(
            Constants::STATUS_SUCCESS,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_SUCCESS,
            (string)$xmlSimple->User->Show->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

    }

    public function testInvalidServiceToken()
    {
        $this->configuration->setServiceToken('NonExistingToken');
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        $expectedStatusCodes = [500, 401];
        static::assertTrue(
            in_array($response->getStatusCode(), $expectedStatusCodes),
            sprintf('Status-code should be %s but is ', implode(' or ', $expectedStatusCodes), $response->getStatusCode())
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);
        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->User->Show->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertRegExp(
            '/^(c005|fw004)$/',
            (string)$xmlSimple->User->Show->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );

    }

    public function testInvalidUsername()
    {
        $this->configuration->setUsername('NonExistingUsername');
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        $expectedStatusCodes = [500, 400];
        static::assertTrue(
            in_array($response->getStatusCode(), $expectedStatusCodes),
            sprintf('Status-code should be %s but is ', implode(' or ', $expectedStatusCodes), $response->getStatusCode())
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);
        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->User->Show->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertRegExp(
            '/^(c008|fw004)$/',
            (string)$xmlSimple->User->Show->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );

    }

    /**
     * @param Configuration $configuration
     * @return string
     */
    private function getRequest(Configuration $configuration)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($configuration)) . '<User>
        <Show>
            <Key>
                <UserType>
                    <Username>' . $this->cdata($configuration->getUsername()) . '</Username>
                </UserType>
            </Key>
        </Show>
    </User>
</SsoRequest>';
    }

}
