<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version1;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\FunctionalTestCase;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Model\User;

/**
 * Class UserAddTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version1
 */
class UserAddTest extends FunctionalTestCase
{
    public function testAddActiveUser()
    {
        $faker = \Faker\Factory::create();
        $user = new User();
        $user->setEmail(Constants::PREFIX . $faker->email);
        $user->setUsername(Constants::PREFIX . $faker->userName);
        $user->setActive(true);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $requestBody = $this->getRequest($user);
        $response = $this->sendPostRequest('User', 'Add', $requestBody);

        static::assertEquals(200, $response->getStatusCode(), $response->getContent());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-active-user.xml',
            'SsoResponse'
        );
        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testAddInactiveUser()
    {
        $faker = \Faker\Factory::create();
        $user = new User();
        $user->setEmail(Constants::PREFIX . $faker->email);
        $user->setUsername(Constants::PREFIX . $faker->userName);
        $user->setActive(false);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $requestBody = $this->getRequest($user);
        $response = $this->sendPostRequest('User', 'Add', $requestBody);

        static::assertEquals(200, $response->getStatusCode(), $response->getContent());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-inactive-user.xml',
            'SsoResponse'
        );
        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    /**
     * @param User $user
     * @return string
     */
    private function getRequest(User $user)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '<User>
        <Add>
            <Value>
                <UserType>
                    <Email>' . $this->cdata($user->getEmail()) . '</Email>
                    <Username>' . $this->cdata($user->getUsername()) . '</Username>
                    <Firstname>' . $this->cdata($user->getFirstname()) . '</Firstname>
                    <Lastname>' . $this->cdata($user->getLastname()) . '</Lastname>
                    <Password>' . $this->cdata($user->getPassword()) . '</Password>
                    <Active>' . ($user->isActive() ? '1' : '0') . '</Active>
                    <AuthId>' . $this->cdata($user->getAuthId()) . '</AuthId>
                    <LdapSearchAttributes>' . $this->cdata($user->getLdapSearchAttributes()) . '</LdapSearchAttributes>
                    <LdapSearchValue>' . $this->cdata($user->getLdapSearchValue()) . '</LdapSearchValue>
                </UserType>
            </Value>
        </Add>
    </User>
</SsoRequest>';
    }
}
