<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version1\XmlStructure;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\FunctionalTestCase;


use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version1\Constants;

/**
 * Class XmlStructureTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version1\XmlStructure
 */
class XmlStructureTest extends FunctionalTestCase
{

    public function testInvalidControllerInXml()
    {
        $requestBody = '<?xml version="1.0" encoding="UTF-8"?><SsoRequest>' . (string)(new Credentials($this->configuration)) . '</SsoRequest>';
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        $expectedStatusCodes = [500, 400];
        static::assertTrue(
            in_array($response->getStatusCode(), $expectedStatusCodes),
            sprintf('Status-code should be %s but is ', implode(' or ', $expectedStatusCodes), $response->getStatusCode())
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error-invalid-controller-in-xml.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Unknown->Unknown->Status,
            'Xml status code does not match!'
        );

        static::assertEquals(
            'fw002', // Since V0.20.0 previous value: x001
            (string)$xmlSimple->Unknown->Unknown->Errors->Error->ErrorCode,
            'Error code does not match!'
        );
    }

    /**
     * Currently this request produces a critical error (status: crit1)
     * but should return status x002
     */
    public function testInvalidActionInXml()
    {
        $requestBody = '<?xml version="1.0" encoding="UTF-8"?><SsoRequest>' . (string)(new Credentials($this->configuration)) . '<User /></SsoRequest>';
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        $expectedStatusCodes = [500, 400];
        static::assertTrue(
            in_array($response->getStatusCode(), $expectedStatusCodes),
            sprintf('Status-code should be %s but is ', implode(' or ', $expectedStatusCodes), $response->getStatusCode())
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error-invalid-action-in-xml.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->User->Unknown->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertRegExp(
            '/^(crit1|fw002)$/',
            (string)$xmlSimple->User->Unknown->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }
}
