<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\ApplicationRole;

/**
 * Class ApplicationRoleAddTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version2
 */
class ApplicationRoleAddTest extends FunctionalTestCase
{
    public function testSuccess()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $faker = \Faker\Factory::create();
        $role = new ApplicationRole();
        $role->setName(Constants::PREFIX . $faker->lastName);
        $role->setDescription($faker->word);

        $requestBody = $this->getRequest($application->getName(), $role->getName(), $role->getDescription());
        $response = $this->sendPostRequest('ApplicationRole', 'Add', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testInvalidApplicationRole()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $role = new ApplicationRole();
        $role->setName('');
        $role->setDescription('');

        $requestBody = $this->getRequest($application->getName(), $role->getName(), $role->getDescription());
        $response = $this->sendPostRequest('ApplicationRole', 'Add', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_FAILURE,
            (string)$xmlSimple->ApplicationRole->Add->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertEquals(
            'r10',
            (string)$xmlSimple->ApplicationRole->Add->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }

    /**
     * @param string $applicationName
     * @param string $roleName
     * @param string $roleDescription
     * @return string
     */
    private function getRequest($applicationName, $roleName, $roleDescription)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <ApplicationRole>
        <Add>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($applicationName) . '</Name>
                </ApplicationType>
            </Key>
            <Value>
                <RoleType>
                    <Name>' . $this->cdata($roleName) . '</Name>
                    <Description>' . $this->cdata($roleDescription) . '</Description>
                </RoleType>
            </Value>
        </Add>
    </ApplicationRole>
</SsoRequest>';
    }
}
