<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2\Credentials;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Configuration;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;

/**
 * Class CredentialsTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version2\Credentials
 */
class CredentialsTest extends FunctionalTestCase
{

    public function testInvalidCredentials()
    {
        $this->configuration->setUsername('NonExistingUser');
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        static::assertEquals(
            400, // Since V0.20.0, previous value: 401
            $response->getStatusCode()
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST, // Since V0.20.0 previous value: Constants::STATUS_UNAUTHORIZED
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST, // Since V0.20.0 previous value: Constants::STATUS_UNAUTHORIZED
            (string)$xmlSimple->Errors->Error->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );
    }

    public function testInvalidServiceToken()
    {
        $this->configuration->setServiceToken('NonExistingToken');
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        static::assertEquals(401, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_UNAUTHORIZED,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_UNAUTHORIZED,
            (string)$xmlSimple->Errors->Error->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertEquals(
            'fw004',
            (string)$xmlSimple->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }

    public function testInvalidUsername()
    {
        $this->configuration->setUsername('NonExistingUsername');
        $requestBody = $this->getRequest($this->configuration);
        $response = $this->sendPostRequest('User', 'Show', $requestBody);

        // Status code check
        static::assertEquals(
            400, // Since V0.20.0, previous value: 401
            $response->getStatusCode()
        );

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlExpectedElement = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlExpectedElement,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );

        // Value check
        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST, // Since V0.20.0 previous value: Constants::STATUS_UNAUTHORIZED
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST, // Since V0.20.0 previous value: Constants::STATUS_UNAUTHORIZED
            (string)$xmlSimple->Errors->Error->Status,
            $this->fXml($requestBody, $xml, 'Xml status code does not match!')
        );

        static::assertEquals(
            'fw004',
            (string)$xmlSimple->Errors->Error->ErrorCode,
            $this->fXml($requestBody, $xml, 'Error code does not match!')
        );
    }

    /**
     * @param Configuration $configuration
     * @return string
     */
    private function getRequest(Configuration $configuration)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($configuration)) . '<User>
        <Show>
            <Key>
                <UserType>
                    <Username>' . $this->cdata($configuration->getUsername()) . '</Username>
                </UserType>
            </Key>
        </Show>
    </User>
</SsoRequest>';
    }

}
