<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Constants;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\User;

/**
 * Class ChangePasswordTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package    Tests\Version2
 */
class ChangePasswordTest extends FunctionalTestCase
{
    public function testChangePasswordOfValidUser()
    {
        $faker = \Faker\Factory::create();

        $user = $this->helperFactory->userAdd()->execute();

        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $requestBody = $this->getRequest($user);
        $response = $this->sendPostRequest('User', 'ChangePassword', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();

        $xmlSimple = simplexml_load_string($xml);

        static::assertEquals(
            Constants::STATUS_BAD_REQUEST,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

    }

    public function testChangePasswordOfInvalidUser()
    {
        $faker = \Faker\Factory::create();
        $user = new User();
        $user->setEmail(Constants::PREFIX . $faker->email);
        $user->setUsername(Constants::PREFIX . $faker->userName);
        $user->setActive(false);
        $user->setFirstname($faker->firstName);
        $user->setLastname($faker->lastName);
        $user->setPassword($faker->password(8, 120) . '_Aa1');

        $requestBody = $this->getRequest($user);
        $response = $this->sendPostRequest('User', 'ChangePassword', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();

        // Value check
        $xmlSimple = simplexml_load_string($xml);
        static::assertEquals(
            Constants::STATUS_NOT_FOUND,
            (string)$xmlSimple->Status,
            $this->fXml($requestBody, $xml, 'Global xml status code does not match!')
        );

        static::assertRegExp(
            Constants::REGEXP_DATE,
            (string)$xmlSimple->Date,
            $this->fXml($requestBody, $xml, 'Date format does not match!')
        );
    }

    /**
     * @param User $user
     * @return string
     */
    private function getRequest(User $user)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '<User>
        <ChangePassword>
            <Key>
                <UserType>
                    <Email>' . $this->cdata($user->getEmail()) . '</Email>
                </UserType>
            </Key>
            <Value>
                <UserType>
                    <Password>' . $this->cdata($user->getPassword()) . '</Password>
                    <NewPasswordConfirm>' . $this->cdata($user->getPassword()) . '</NewPasswordConfirm>
                </UserType>
            </Value>
        </ChangePassword>
    </User>
</SsoRequest>';
    }
}
