<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Functional\Services\Tests\Version2\UserSearch\FindByApplication;

use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Credentials;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\FunctionalTestCase;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\Application;
use Sso\WebserviceBundle\Tests\Functional\Services\Helper\Version2\Model\ApplicationAttribute;

/**
 * Class FindByApplicationAttributeTest
 *
 * @copyright  2017 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Tests\Version2\UserSearch\FindByApplicationAttributeTest
 */
class FindByApplicationAttributeTest extends FunctionalTestCase
{

    public function testEmptyResultByValidApplicationAttribute()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $requestBody = $this->getRequest($application, $applicationAttribute);
        $response = $this->sendPostRequest('UserSearch', 'FindByApplicationAttribute', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-empty-result.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindSingleUserByValidApplicationAttribute()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $user = $this->helperFactory->userAdd()->execute();

        $this->helperFactory->userApplicationAdd()->execute($user, $application);
        $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);

        $requestBody = $this->getRequest($application, $applicationAttribute);
        $response = $this->sendPostRequest('UserSearch', 'FindByApplicationAttribute', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-single-user.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testFindMultipleUserByValidApplicationAttribute()
    {
        $application = $this->helperFactory->applicationAdd()->execute();
        $this->helperFactory->userPermissionAdd()->execute($application);

        $applicationAttribute = $this->helperFactory->applicationAttributeAdd()->execute($application);

        $count = 3;
        do {
            $user = $this->helperFactory->userAdd()->execute();
            $this->helperFactory->userApplicationAdd()->execute($user, $application);
            $this->helperFactory->userApplicationAttributeAdd()->execute($user, $application, $applicationAttribute);
        } while (--$count > 0);

        $requestBody = $this->getRequest($application, $applicationAttribute);
        $response = $this->sendPostRequest('UserSearch', 'FindByApplicationAttribute', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-success-multiple-users.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    public function testInvalidValidApplicationAttribute()
    {
        $application = new Application();
        $application->setName('NonExistingApplication');

        $applicationAttribute = new ApplicationAttribute('NonExistingApplicationAttribute');
        $applicationAttribute->setValue('NonExistingAttribute');

        $requestBody = $this->getRequest($application, $applicationAttribute);
        $response = $this->sendPostRequest('UserSearch', 'FindByApplicationAttribute', $requestBody);

        static::assertEquals(200, $response->getStatusCode());

        $xml = $response->getContent();
        $xmlElement = $this->loadResponse($xml);

        $xmlElementExpected = $this->loadXmlDomElement(
            __DIR__ . '/xml/response-structure-error.xml',
            'SsoResponse'
        );

        static::assertEqualXMLStructure(
            $xmlElementExpected,
            $xmlElement,
            false,
            $this->fXml($requestBody, $xml, 'Xml structure check failed')
        );
    }

    /**
     * @param Application $application
     * @param ApplicationAttribute $applicationAttribute
     * @return string
     */
    private function getRequest(Application $application, ApplicationAttribute $applicationAttribute)
    {
        return '<?xml version="1.0" encoding="UTF-8"?>
<SsoRequest>' . (string)(new Credentials($this->configuration)) . '
    <UserSearch>
        <FindByApplicationAttribute>
            <Key>
                <ApplicationType>
                    <Name>' . $this->cdata($application->getName()) . '</Name>
                </ApplicationType>
                <AttributeType>
                    <Name>' . $this->cdata($applicationAttribute->getName()) . '</Name>
                    <Value>' . $this->cdata($applicationAttribute->getValue()) . '</Value>
                </AttributeType>
            </Key>
        </FindByApplicationAttribute>
    </UserSearch>
</SsoRequest>';
    }
}
