<?php

namespace Sso\WebserviceBundle\Tests;

use Doctrine\Common\DataFixtures\ReferenceRepository;
use Liip\FunctionalTestBundle\Test\WebTestCase;
use Sso\WebserviceBundle\Api\Manager as ApiManager;
use Sso\WebserviceBundle\Api\Response\Builder as XmlResponse;

/**
 * Class FunctionalTestCase
 * @package Sso\WebserviceBundle\Tests
 */
class FunctionalTestCase extends WebTestCase
{
    use LoadFixturesTrait;

    /**
     * Xml credentials
     *
     * @var string
     */
    protected $xmlCredentials;

    /**
     * Set to controller name
     *
     * @var string
     */
    protected $controllerName;

    /**
     * @var ApiManager
     */
    protected $apiM;
    /**
     * Webservice service token
     *
     * @var string
     */
    protected $ServiceToken = 'V2030cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa';

    /**
     * Webservice service name
     *
     * @var string
     */
    protected $ServiceName = 'MyService';

    /**
     * Webservice country code
     *
     * @var string
     */
    protected $ServiceCountryCode = 'DE';

    /**
     * Webservice user identifier
     *
     * @var string
     */
    protected $idpUserIdentifier = null;

    /**
     * @var string
     */
    protected $idpTestUsername = "user-api-grant-access";

    /**
     * @var string
     */
    protected $idpTestUserPwd = 'SsO#12Test';

    /**
     * Application name for testing
     *
     * @var string
     */
    protected $ApplicationName;

    /**
     * Attribute name for testing
     *
     * @var string
     */
    protected $AttributeName;

    /**
     * Role name for testing
     *
     * @var string
     */
    protected $RoleName;

    /**
     * Webservice country code
     *
     * @var string
     */
    protected $userName = 'userNameString';

    /**
     * Username for testing
     *
     * @var string
     */
    protected $Username = "minduserWorld";

    /**
     * Email for testing
     *
     * @var string
     */
    protected $Email = "world@minduser.de";

    /**
     * @var ReferenceRepository
     */
    protected $webserviceFixtures;

    /**
     * @var ReferenceRepository
     */
    protected $serviceFixtures;

    /**
     * WebserviceTestCase constructor.
     * @param null $name
     * @param array $data
     * @param string $dataName
     */
    public function __construct($name = null, array $data = [], $dataName = '')
    {
        parent::__construct($name, $data, $dataName);
        date_default_timezone_set('Europe/Berlin');

    }

    public function setUp()
    {
        parent::setUp();

        $this->loadApplicationFixtures([$this, 'loadFixtures']);

        $client = static::createClient();
        $container = $client->getContainer();
        $logger = $container->get('logger');
        $this->apiM = new ApiManager($container, $logger);

        $this->idpUserIdentifier = $this->apiM->container->get('sso_tools_user_identifier.api_controller')->userIdentifierGet($this->idpTestUsername,
            $this->idpTestUserPwd);

        $this->xmlCredentials = "<Credentials>
                    <ServiceProvider>
                        <ServiceToken>" . $this->ServiceToken . "</ServiceToken>
                        <ServiceName>" . $this->ServiceName . "</ServiceName>
                    </ServiceProvider>
                    <ServiceTrigger>
                        <Username>" . $this->idpTestUsername . "</Username>
                        <UserIdentifier>" . $this->idpUserIdentifier . "</UserIdentifier>
                    </ServiceTrigger>
                    <ServiceCountry>
                        <Code>" . $this->ServiceCountryCode . "</Code>
                    </ServiceCountry>
                </Credentials>";
    }


    /**
     * Send webservice request
     *
     * @param string $xml
     * @param string $controller
     * @param string $action
     * @return string
     */
    protected function sendRequest($xml, $controller, $action)
    {
        $header = array(
            'HTTP_API_VERSION' => '1',
            'HTTP_API_CONTROLLER' => $controller,
            'HTTP_API_ACTION' => $action,
            'HTTP_REMOTE_ADDR' => '127.0.0.1',
            'CONTENT_TYPE' => 'text/xml',
        );
        $client = static::createClient(array(), $header);
        $client->request('POST', '/', array(), array(), array(), $xml);
        return $client->getResponse();
    }

    /**
     * Get current controller name
     *
     * @return string
     */
    protected function getControllerName()
    {
        return $this->controllerName;
    }

    /**
     * Xml response document
     *
     * @return XmlResponse
     */
    protected function xmlResponse()
    {
        return new XmlResponse();
    }

    protected function tearDown()
    {
        parent::tearDown();
        $this->apiM = null;
        gc_collect_cycles();
    }
}
