<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2019 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests;

use Sso\WebserviceBundle\DataFixtures\ORM\Webservice as WebserviceFixtures;
use Sso\WebserviceBundle\DataFixtures\ORM\ServiceProvider as ServiceProviderFixtures;
use Sso\WebserviceBundle\DataFixtures\ORM\ReadWrite as ReadWriteFixtures;
use Sso\WebserviceBundle\DataFixtures\ORM\Backend as BackendFixtures;

/**
 * Trait LoadFixturesTrait
 * @package Sso\WebserviceBundle\Tests
 */
trait LoadFixturesTrait
{
    /**
     * Load all fixtures for functional tests
     *
     * @param callable $loadFixtures
     */
    private function loadApplicationFixtures(callable $loadFixtures)
    {
        $loadFixtures(
            [
                WebserviceFixtures\LoadApplications::class,
                WebserviceFixtures\LoadUserApplications::class
            ]
            , 'Webservice'
        );

        $loadFixtures(
            [
                ServiceProviderFixtures\LoadServiceNames::class,
                ServiceProviderFixtures\LoadServiceNames2Services::class,
                ServiceProviderFixtures\LoadServices::class,
                ServiceProviderFixtures\LoadTokens::class,
                ServiceProviderFixtures\LoadTokens2ServiceNames::class,
            ],
            'ServiceProvider'
        );

        $loadFixtures(
            [
                ReadWriteFixtures\LoadWsseTokens::class,
            ],
            'ReadWrite'
        );

        $loadFixtures(
            [
                BackendFixtures\LoadUsers::class,
            ],
            'Backend'
        );
    }
}
