<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services;

use Sso\WebserviceBundle\Api\ApiVersionInterface;
use Sso\WebserviceBundle\Services\ApiVersionInflector;
use InvalidArgumentException;

/**
 * Class ApiVersionInflectorTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services
 */
class ApiVersionInflectorTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @dataProvider versionDataProvider
     * @param $intVersion
     * @param $strVersion
     */
    public function testClassnameSuccess($intVersion, $strVersion)
    {
        $apiVersion = $this->getApiVersion($intVersion);
        $apiVersionInflector = new ApiVersionInflector($apiVersion);

        $namespace = __NAMESPACE__;
        $classname = 'RunAway';

        $expected = $namespace . '\\' . $strVersion . '\\' . $classname;
        self::assertSame($expected, $apiVersionInflector->inflect($namespace, $classname));
    }

    /**
     * @dataProvider versionDataProvider
     * @param $intVersion
     * @param $strVersion
     */
    public function testNamespaceError($intVersion, $strVersion)
    {
        $apiVersion = $this->getApiVersion($intVersion);
        $apiVersionInflector = new ApiVersionInflector($apiVersion);

        $namespace = __NAMESPACE__;
        $classname = 'Classname Containing Whitespace';

        $this->expectException(InvalidArgumentException::class);
        $apiVersionInflector->inflect($namespace, $classname);
    }

    /**
     * @dataProvider versionDataProvider
     * @param $intVersion
     * @param $strVersion
     */
    public function testClassnameError($intVersion, $strVersion)
    {
        $apiVersion = $this->getApiVersion($intVersion);
        $apiVersionInflector = new ApiVersionInflector($apiVersion);

        $namespace = 'Invalid\\Namespace\\Containing Whitspace';
        $classname = 'RunAway';

        $this->expectException(InvalidArgumentException::class);
        $apiVersionInflector->inflect($namespace, $classname);
    }

    public function versionDataProvider()
    {
        $params = array();
        $params[] = array(3, 'Version3');
        $params[] = array(6, 'Version6');
        $params[] = array(1, 'Version1');
        return $params;
    }

    /**
     * @param int $version
     * @return ApiVersionInterface
     */
    private function getApiVersion($version)
    {
        $apiVersion = $this->createMock(ApiVersionInterface::class);
        $apiVersion->method('toString')->willReturn(sprintf('Version%d', $version));
        $apiVersion->method('toInt')->willReturn((int)$version);
        return $apiVersion;
    }
}
