<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\User\Add\Request\Version2;

use Sso\WebserviceBundle\Services\User\Add\Request\Version2\RequestParser;
use Sso\WebserviceBundle\Services\User\Add\RequestData\Factory as RequestDataFactory;
use Sso\WebserviceBundle\Services\User\Add\Request\Version2\Factory as RequestFactory;
use Sso\WebserviceBundle\Tests\Services\ServicesKernelTestCase;
use Sso\WebserviceBundle\Api\ApiManagerInterface;

/**
 * Class RequestParserTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\Request\Version2
 */
class FactoryTest extends ServicesKernelTestCase
{

    /**
     * @var ApiManagerInterface
     */
    protected $apiManager;

    protected function setUp()
    {
        parent::setUp();
        $this->apiManager = $this->container->get('service_api_manager');
    }

    public function testFactoryRequestParser()
    {
        $requestDataFactory = new RequestDataFactory();
        $factory = new RequestFactory($this->apiManager, $requestDataFactory);

        $this->assertInstanceOf( RequestParser::class, $factory->requestParser() );
    }
}
