<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\UserApplication\Show\ResponseData;

use Sso\WebserviceBundle\Api\ApiManagerInterface;
use Sso\WebserviceBundle\Services\UserApplication\Show\ResponseData\ApplicationType as ResponseDataApplicationType;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class UserTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\ResponseData
 */
class ApplicationTypeTest extends \PHPUnit\Framework\TestCase
{

    public function testCreateDTO()
    {
        $faker = \Faker\Factory::create();
        $appName = $faker->uuid;
        $appTypeDTO = new ResponseDataApplicationType();

        $appTypeDTO->setName($appName);
        $appTypeDTO->setActive(true);

        $this->assertSame($appTypeDTO->getName(), $appName);
        $this->assertSame($appTypeDTO->isActive(), true);

        $appTypeDTO->setActive(null);
        $this->assertSame($appTypeDTO->isActive(), null);

        $appTypeDTO->setActive(true);
        $this->assertSame($appTypeDTO->isActive(), true);
    }
}
