<?php

/**
 * Lifestyle Webconsulting GmbH
 *
 * LICENSE: This Software is the property of Lifestyle Webconsulting GmbH (Aschaffenburg, Germany)
 * and is private by copyright law - it is NOT Freeware.
 *
 * Any unauthorized use of this software without a valid license
 * is a violation of the license agreement and will be prosecuted by
 * civil and criminal law.
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 */

namespace Sso\WebserviceBundle\Tests\Services\UserApplication\ShowDetails\Request\Version2;

use Sso\WebserviceBundle\ErrorHandler\ErrorHandlerInterface;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\Request\Version2\RequestParser;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\RequestData\User as RequestDataUser;
use Sso\WebserviceBundle\Services\UserApplication\ShowDetails\RequestData\Factory as RequestDataFactory;
use JMS\Serializer\SerializerBuilder;
use Symfony\Component\Validator\Validator\ValidatorInterface;

/**
 * Class RequestParserTest
 *
 * @copyright  2016 Lifestyle Webconsulting GmbH
 * @link       http://www.life-style.de
 * @package Sso\WebserviceBundle\Tests\Services\User\Show\Request\Version2
 */
class RequestParserTest extends \PHPUnit\Framework\TestCase
{
    /**
     * @var \Faker\Generator
     */
    private $faker;

    private $validServiceToken = 'V2030cOhc6Vttcxs6r6bmtdlc8Z1ryTN1TQ16pjivEcprZhye9e17ba7508a4358f99c8ba52ded0f70RnZDhDyKMXLEWobXI2ZOrJ7mXjcPJJNk7wxoAw8WUTk0IMYa';
    private $validServiceName = 'MyService';
    private $validUserIdentifier = '5e211de5c4aa76564fc5e3657a7946aab3e2dbe60a773117568b3e67a2223a2c6878e5d25ee70588b19728f010417388f590128beced60402c7b8036b725ba71';
    private $validUsername = 'test@example.com';
    private $validServiceCountryCode = 'DE';

    protected function setUp()
    {
        $this->faker = \Faker\Factory::create();
    }

    public function testParseSuccess()
    {
        $identifier = $this->faker->email;

        $serializer = SerializerBuilder::create()->build();

        $factory = new RequestDataFactory();

        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $errorHandler
            ->expects(self::never())
            ->method('addError');

        $validator = $this->createMock(ValidatorInterface::class);

        $requestParser = new RequestParser(
            $serializer,
            $factory,
            $errorHandler,
            $validator
        );

        /** @var RequestDataUser $model */
        $model = $requestParser->parse($this->generateSuccessXml($identifier));

        self::assertInstanceOf(RequestDataUser::class, $model);
        self::assertSame($identifier, $model->getIdentifier());
    }

    public function testParseXmlInvalidError()
    {
        $serializer = SerializerBuilder::create()->build();

        $factory = new RequestDataFactory();

        $errorHandler = $this->createMock(ErrorHandlerInterface::class);
        $errorHandler
            ->expects(self::once())
            ->method('addError');

        $validator = $this->createMock(ValidatorInterface::class);

        $requestParser = new RequestParser(
            $serializer,
            $factory,
            $errorHandler,
            $validator
        );

        $requestParser->parse($this->generateErrorXml($this->faker->email));
    }

    /**
     * @param string $identifier email or username or guid
     * @return string
     */
    private function generateSuccessXml($identifier)
    {
        return '<?xml version="1.0"?>
<SsoRequest>
    <Credentials>
        <ServiceProvider>
            <ServiceToken>' . $this->validServiceToken . '</ServiceToken>
            <ServiceName>' . $this->validServiceName . '</ServiceName>
        </ServiceProvider>
        <ServiceTrigger>
            <Username>' . $this->validUsername . '</Username>
            <UserIdentifier>' . $this->validUserIdentifier . '</UserIdentifier>
        </ServiceTrigger>
        <ServiceCountry>
            <Code>' . $this->validServiceCountryCode . '</Code>
        </ServiceCountry>
    </Credentials>
  <UserApplication>
    <ShowDetails>
      <Key>
        <UserType>
          <Identifier>'.$identifier.'</Identifier>
        </UserType>
        <ApplicationType>
          <Name>TestApplication</Name>
        </ApplicationType>
      </Key>
    </ShowDetails>
  </UserApplication>
</SsoRequest>';
    }

    /**
     * @param string $identifier email or username or guid
     * @return string
     */
    private function generateErrorXml($identifier)
    {
        return '<?xml version="1.0"?>
                    <SsoRequest>
                        <Credentials>
                            <ServiceProvider>
                                <ServiceToken>' . $this->validServiceToken . '</ServiceToken>
                                <ServiceName>' . $this->validServiceName . '</ServiceName>
                            </ServiceProvider>
                            <ServiceTrigger>
                                <Username>' . $this->validUsername . '</Username>
                                <UserIdentifier>' . $this->validUserIdentifier . '</UserIdentifier>
                            </ServiceTrigger>
                            <ServiceCountry>
                                <Code>' . $this->validServiceCountryCode . '</Code>
                            </ServiceCountry>
                        </Credentials>
  <UserApplication>
    <ShowDetails>
      <Key>
        <UserType>
          <IdentifierFail>TestIdentifier</IdentifierFail>
        </UserType>
        <ApplicationType>
          <Name>TestApplication</Name>
        </ApplicationType>
      </Key>
    </ShowDetails>
  </UserApplication>
                    </SsoRequest>';
    }
}
